/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.ListNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.VerticalIdList;
import java.util.Arrays;
import java.util.LinkedList;

public class SparseIdList {
    private TransactionIds[] vector;
    private int absoluteSupport;

    public SparseIdList(int rows) {
        this.vector = new TransactionIds[rows];
    }

    public int length() {
        return this.vector.length;
    }

    public void addElement(int row, int value) {
        if (this.vector[row] == null) {
            this.vector[row] = new TransactionIds();
            ++this.absoluteSupport;
        }
        this.vector[row].add(new ListNode(value));
    }

    public ListNode getElement(int row, int col) {
        if (this.vector[row] != null && col < this.vector[row].size()) {
            return (ListNode)this.vector[row].get(col);
        }
        return null;
    }

    public static SparseIdList IStep(SparseIdList a, SparseIdList b) {
        SparseIdList sparseIdList = new SparseIdList(a.length());
        for (int i = 0; i < a.length(); ++i) {
            ListNode aNode = a.getElement(i, 0);
            ListNode bNode = b.getElement(i, 0);
            while (aNode != null && bNode != null) {
                if (aNode.getColumn() == bNode.getColumn()) {
                    sparseIdList.addElement(i, bNode.getColumn());
                    aNode = aNode.next();
                    bNode = bNode.next();
                    continue;
                }
                if (aNode.getColumn() > bNode.getColumn()) {
                    bNode = bNode.next();
                    continue;
                }
                aNode = aNode.next();
            }
        }
        return sparseIdList;
    }

    public VerticalIdList getStartingVIL() {
        ListNode[] vilElements = new ListNode[this.length()];
        for (int i = 0; i < vilElements.length; ++i) {
            vilElements[i] = this.getElement(i, 0);
        }
        return new VerticalIdList(vilElements, this.absoluteSupport);
    }

    public int getAbsoluteSupport() {
        return this.absoluteSupport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SparseIdList)) {
            return false;
        }
        SparseIdList that = (SparseIdList)o;
        for (int i = 0; i < this.vector.length; ++i) {
            TransactionIds these = this.vector[i];
            TransactionIds those = that.vector[i];
            if (these == null && those == null) continue;
            if (these == null || those == null) {
                return false;
            }
            if (these.size() != those.size()) {
                return false;
            }
            for (int j = 0; j < these.size(); ++j) {
                if (((ListNode)these.get(j)).getColumn() == ((ListNode)those.get(j)).getColumn()) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.vector != null ? Arrays.hashCode(this.vector) : 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.vector.length; ++i) {
            TransactionIds currList = this.vector[i];
            if (currList != null) {
                for (int j = 0; j < currList.size(); ++j) {
                    buf.append(((ListNode)currList.get(j)).toString() + " ");
                }
                buf.append("\n");
                continue;
            }
            buf.append("null \n");
        }
        return buf.toString();
    }

    class TransactionIds
    extends LinkedList<ListNode> {
        private static final long serialVersionUID = 1L;

        TransactionIds() {
        }

        @Override
        public boolean add(ListNode e) {
            if (this.size() != 0) {
                ListNode last = (ListNode)this.getLast();
                last.setNext(e);
            }
            return super.add(e);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.size(); ++i) {
                buf.append(((ListNode)this.get(i)).toString());
            }
            return buf.toString();
        }
    }
}

