/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.VerticalIdList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.NodeType;
import java.util.LinkedList;
import java.util.List;

public class ClosedSequenceNode {
    private VerticalIdList vil;
    private List<ClosedSequenceNode> children = new LinkedList<ClosedSequenceNode>();
    private ClosedSequenceNode parent;
    private Sequence sequence;
    private NodeType type = NodeType.toCheck;
    private int absoluteSupport;

    ClosedSequenceNode(int sizePositionList) {
        this.sequence = new Sequence(new Itemset[0]);
        this.absoluteSupport = sizePositionList;
    }

    ClosedSequenceNode(ClosedSequenceNode parent, Sequence sequence, VerticalIdList vil, int absoluteSupport) {
        this.vil = vil;
        this.parent = parent;
        this.sequence = sequence;
        this.absoluteSupport = absoluteSupport;
    }

    public List<ClosedSequenceNode> getChildren() {
        return this.children;
    }

    public ClosedSequenceNode getParent() {
        return this.parent;
    }

    public VerticalIdList getVerticalIdList() {
        return this.vil;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public int getAbsoluteSupport() {
        return this.absoluteSupport;
    }

    public String toString() {
        return this.sequence.toString() + " #SUP: " + this.absoluteSupport;
    }

    public boolean containsLastItemset(ClosedSequenceNode n) {
        if (this.sequence.getLastItemset().equals(n.sequence.getLastItemset())) {
            return false;
        }
        return this.sequence.getLastItemset().contains(n.getSequence().getLastItemset());
    }
}

