/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.cost;

import ca.pfv.spmf.algorithms.sequentialpatterns.cost.DataMapper;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.Event;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceDatabase {
    List<Event[]> sequences = new ArrayList<Event[]>();
    Map<Integer, Double> sequenceIdUtility = new HashMap<Integer, Double>();
    long eventOccurrenceCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        this.eventOccurrenceCount = 0L;
        this.sequences = new ArrayList<Event[]>();
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int lineNumber = 0;
            double avrLength = 0.0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] tokens = thisLine.split(" ");
                avrLength += (double)(tokens.length - 2);
                Event[] sequence = new Event[tokens.length - 1];
                String sequenceUtilityString = tokens[tokens.length - 1];
                int positionColons = sequenceUtilityString.indexOf(58);
                Double sequenceUtility = Double.parseDouble(sequenceUtilityString.substring(positionColons + 1));
                if (this.sequenceIdUtility.get(lineNumber) == null) {
                    this.sequenceIdUtility.put(lineNumber, sequenceUtility);
                    ++lineNumber;
                }
                for (int i = 0; i < tokens.length - 1; ++i) {
                    String currentToken = tokens[i].trim();
                    if (currentToken.length() != 0 && currentToken.charAt(0) != '-') {
                        Event event;
                        int positionLeftBracketString = currentToken.indexOf(91);
                        int positionRightBracketString = currentToken.indexOf(93);
                        String itemString = currentToken.substring(0, positionLeftBracketString);
                        Integer item = DataMapper.mapKV(itemString);
                        String costString = currentToken.substring(positionLeftBracketString + 1, positionRightBracketString);
                        double cost = Integer.parseInt(costString);
                        sequence[i] = event = new Event(item, cost);
                        continue;
                    }
                    Integer current = Integer.parseInt(currentToken);
                    sequence[i] = new Event(current, -99.0);
                }
                this.sequences.add(sequence);
            }
        }
    }

    public void print() {
        System.out.println("============  SEQUENCE DATABASE ==========");
        System.out.println(this.toString());
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        double meansize = (float)this.eventOccurrenceCount / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.sequences.size(); ++i) {
            buffer.append(i + ":  ");
            Event[] sequence = this.sequences.get(i);
            boolean startingANewItemset = true;
            for (Event token : sequence) {
                if (token.getId() >= 0) {
                    if (startingANewItemset) {
                        startingANewItemset = false;
                        buffer.append("(");
                    } else {
                        buffer.append(" ");
                    }
                    buffer.append(DataMapper.getKey(token.getId()));
                    buffer.append('[');
                    buffer.append(token.getCost());
                    buffer.append(']');
                    ++this.eventOccurrenceCount;
                    continue;
                }
                if (token.getId() == -1) {
                    buffer.append(")");
                    startingANewItemset = true;
                    continue;
                }
                if (token.getId() == -2) break;
            }
            buffer.append(System.lineSeparator());
        }
        return buffer.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Event[]> getSequences() {
        return this.sequences;
    }
}

