/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Itemset {
    private final List<ItemSimple> items = new ArrayList<ItemSimple>();
    private long timestamp = 0L;

    public Itemset(ItemSimple item, long timestamp) {
        this.addItem(item);
        this.setTimestamp(timestamp);
    }

    public Itemset() {
    }

    public void addItem(ItemSimple item) {
        this.items.add(item);
    }

    public List<ItemSimple> getItems() {
        return this.items;
    }

    public ItemSimple get(int index) {
        return this.items.get(index);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (ItemSimple attribute : this.items) {
            r.append(attribute.toString());
            r.append(' ');
        }
        return r.toString();
    }

    public Itemset cloneItemSetMinusItems(Map<ItemSimple, Set<Integer>> mapSequenceID, double relativeMinsup) {
        Itemset itemset2 = new Itemset();
        itemset2.timestamp = this.timestamp;
        for (ItemSimple item : this.items) {
            if (!((double)mapSequenceID.get(item).size() >= relativeMinsup)) continue;
            itemset2.addItem(item);
        }
        return itemset2;
    }

    public Itemset cloneItemSet() {
        Itemset itemset2 = new Itemset();
        itemset2.timestamp = this.timestamp;
        itemset2.getItems().addAll(this.items);
        return itemset2;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int size() {
        return this.items.size();
    }
}

