/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sequence {
    private final List<Itemset> itemsets = new ArrayList<Itemset>();
    private int id;
    private Set<Integer> sequencesID = null;

    public Sequence(int id) {
        this.id = id;
    }

    public String getRelativeSupportFormated(int databaseSize) {
        double support = (double)this.sequencesID.size() / (double)databaseSize;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(support);
    }

    public int getAbsoluteSupport() {
        return this.sequencesID.size();
    }

    public void addItemset(Itemset itemset2) {
        this.itemsets.add(itemset2);
    }

    public Sequence cloneSequence() {
        Sequence sequence = new Sequence(this.getId());
        for (Itemset itemset2 : this.itemsets) {
            sequence.addItemset(itemset2.cloneItemSet());
        }
        return sequence;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            r.append("{t=");
            r.append(itemset2.getTimestamp());
            r.append(", ");
            for (ItemSimple item : itemset2.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        if (this.getSequencesID() != null) {
            r.append("  Sequence ID: ");
            for (Integer id : this.getSequencesID()) {
                r.append(id);
                r.append(' ');
            }
        }
        return r.append("    ").toString();
    }

    public String toStringShort() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            r.append("{t=");
            r.append(itemset2.getTimestamp());
            r.append(", ");
            for (ItemSimple item : itemset2.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public String itemsetsToString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            r.append("{t=");
            r.append(itemset2.getTimestamp());
            r.append(", ");
            for (ItemSimple item : itemset2.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public ItemSimple getIthItem(int i) {
        for (int j = 0; j < this.itemsets.size(); ++j) {
            if (i < this.itemsets.get(j).size()) {
                return this.itemsets.get(j).get(i);
            }
            i -= this.itemsets.get(j).size();
        }
        return null;
    }

    public int size() {
        return this.itemsets.size();
    }

    public Set<Integer> getSequencesID() {
        return this.sequencesID;
    }

    public void setSequencesID(Set<Integer> sequencesID) {
        this.sequencesID = sequencesID;
    }

    public int getItemOccurencesTotalCount() {
        int count = 0;
        for (Itemset itemset2 : this.itemsets) {
            count += itemset2.size();
        }
        return count;
    }

    public long getTimeLength() {
        return this.itemsets.get(this.itemsets.size() - 1).getTimestamp() - this.itemsets.get(0).getTimestamp();
    }

    public int strictlyContains(Sequence sequence2) {
        int retour = this.strictlyContainsHelper(sequence2, 0, 0, 0L, 0L);
        if (retour == 2) {
            return this.size() == sequence2.size() ? 2 : 1;
        }
        return retour;
    }

    private int strictlyContainsHelper(Sequence sequence2, int index, int index2, long previousTimeStamp, long previousTimeStamp2) {
        if (index == this.size()) {
            return 0;
        }
        if (this.size() - index < sequence2.size() - index2) {
            return 0;
        }
        int returnValue = 0;
        for (int i = index; i < this.size(); ++i) {
            boolean sameSize;
            long interval1 = this.get(i).getTimestamp() - previousTimeStamp;
            long interval2 = sequence2.get(index2).getTimestamp() - previousTimeStamp2;
            if (!this.get(i).getItems().containsAll(sequence2.get(index2).getItems()) || interval1 != interval2) continue;
            boolean bl = sameSize = this.get(i).getItems().size() == sequence2.get(index2).size();
            if (sequence2.size() - 1 == index2) {
                if (sameSize) {
                    return 2;
                }
                returnValue = 1;
                continue;
            }
            int resultat = this.strictlyContainsHelper(sequence2, i + 1, index2 + 1, this.get(i).getTimestamp(), sequence2.get(index2).getTimestamp());
            if (resultat == 2 && sameSize) {
                return 2;
            }
            if (resultat == 0) continue;
            returnValue = 1;
        }
        return returnValue;
    }

    public Sequence cloneSequenceMinusItems(Map<ItemSimple, Set<Integer>> mapSequenceID, double relativeMinSup) {
        Sequence sequence = new Sequence(this.getId());
        for (Itemset itemset2 : this.itemsets) {
            Itemset newItemset = itemset2.cloneItemSetMinusItems(mapSequenceID, relativeMinSup);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public void setID(int id2) {
        this.id = id2;
    }
}

