/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemValued;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08.Cluster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SequenceDatabase {
    private final List<Sequence> sequences = new ArrayList<Sequence>();
    private Cluster cluster = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.processSequence(thisLine.split(" "));
            }
        }
    }

    void processSequence(String[] tokens) {
        Sequence sequence = new Sequence(this.sequences.size());
        Itemset itemset2 = new Itemset();
        for (String integer : tokens) {
            if (integer.codePointAt(0) == 60) {
                String value = integer.substring(1, integer.length() - 1);
                itemset2.setTimestamp(Long.parseLong(value));
                continue;
            }
            if (integer.equals("-1")) {
                sequence.addItemset(itemset2);
                itemset2 = new Itemset();
                continue;
            }
            if (integer.equals("-2")) {
                if (itemset2.size() > 0) {
                    sequence.addItemset(itemset2);
                    itemset2 = new Itemset();
                }
                this.sequences.add(sequence);
                continue;
            }
            int indexLeftParenthesis = integer.indexOf("(");
            if (indexLeftParenthesis != -1) {
                int indexRightParenthesis = integer.indexOf(")");
                int value = Integer.parseInt(integer.substring(indexLeftParenthesis + 1, indexRightParenthesis));
                integer = integer.substring(0, indexLeftParenthesis);
                ItemValued item = new ItemValued(Integer.parseInt(integer), value);
                itemset2.addItem(item);
                continue;
            }
            ItemSimple item = new ItemSimple(Integer.parseInt(integer));
            if (itemset2.getItems().contains(item)) continue;
            itemset2.addItem(item);
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void print() {
        System.out.println("============  Context ==========");
        for (Sequence sequence : this.sequences) {
            System.out.print(sequence.getId() + ":  ");
            sequence.print();
            System.out.println("");
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public Set<Integer> getSequenceIDs() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Sequence sequence : this.getSequences()) {
            set.add(sequence.getId());
        }
        return set;
    }

    Cluster getCluster() {
        return this.cluster;
    }

    void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

