/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns;

import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID.AlgoAprioriTID;
import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTIDClose.AlgoAprioriTIDClose;
import ca.pfv.spmf.algorithms.frequentpatterns.charm.AlgoCharm_Bitset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPatterns;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPatternsDatabase;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemsets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AlgoDim {
    private MDPatterns patterns = new MDPatterns("Frequent MD Patterns");
    private int dimensionsCount;
    private boolean findClosedPatterns;
    private boolean findClosedPatternsWithCharm;
    private Map<Integer, String> mapItemIdIdentifier = new HashMap<Integer, String>();
    private Map<String, Integer> mapIdentifierItemId = new HashMap<String, Integer>();
    int lastUniqueItemIdGiven = 0;

    public AlgoDim(boolean findClosedPatterns, boolean findClosedPatternsWithCharm) {
        this.findClosedPatterns = findClosedPatterns;
        this.findClosedPatternsWithCharm = findClosedPatternsWithCharm;
    }

    public MDPatterns runAlgorithm(MDPatternsDatabase mdPatDatabase, double minsupp) throws IOException {
        this.patterns = new MDPatterns("FREQUENT MD Patterns");
        this.dimensionsCount = mdPatDatabase.getMDPatterns().get(0).size();
        if (this.findClosedPatternsWithCharm) {
            TransactionDatabase contextCharm = new TransactionDatabase();
            for (MDPattern pattern : mdPatDatabase.getMDPatterns()) {
                contextCharm.addTransaction(this.convertPatternToItemset(pattern));
            }
            AlgoCharm_Bitset charm = new AlgoCharm_Bitset();
            Itemsets frequentPatterns = charm.runAlgorithm(null, contextCharm, minsupp, true, 10000);
            int maxSupport = 0;
            for (List<Itemset> itemsets : frequentPatterns.getLevels()) {
                for (Itemset itemset2 : itemsets) {
                    MDPattern pattern = this.convertItemsetCharmToPattern(itemset2);
                    this.patterns.addPattern(pattern, pattern.size());
                    if (itemset2.getAbsoluteSupport() <= maxSupport) continue;
                    maxSupport = itemset2.getAbsoluteSupport();
                }
            }
            if (maxSupport < contextCharm.size()) {
                this.patterns.addPattern(this.convertItemsetCharmToPattern(new Itemset()), 0);
            }
        } else if (this.findClosedPatterns) {
            TransactionDatabase database = new TransactionDatabase();
            for (MDPattern pattern : mdPatDatabase.getMDPatterns()) {
                database.addTransaction(this.convertPatternToItemset(pattern));
            }
            AlgoAprioriTIDClose apriori = new AlgoAprioriTIDClose();
            ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets closedItemsets = apriori.runAlgorithm(database, minsupp, null);
            for (List<ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset> itemsets : closedItemsets.getLevels()) {
                for (ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset itemset3 : itemsets) {
                    MDPattern pattern = this.convertItemsetToPattern(itemset3);
                    this.patterns.addPattern(pattern, pattern.size());
                }
            }
        } else {
            TransactionDatabase database = new TransactionDatabase();
            for (MDPattern pattern : mdPatDatabase.getMDPatterns()) {
                database.addTransaction(this.convertPatternToItemset(pattern));
            }
            AlgoAprioriTID apriori = new AlgoAprioriTID();
            ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets closedItemsets = apriori.runAlgorithm(database, minsupp);
            apriori.setEmptySetIsRequired(true);
            for (List<ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset> itemsets : closedItemsets.getLevels()) {
                for (ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset itemset4 : itemsets) {
                    MDPattern pattern = this.convertItemsetToPattern(itemset4);
                    this.patterns.addPattern(pattern, pattern.size());
                }
            }
            this.patterns.addPattern(this.convertItemsetCharmToPattern(new Itemset()), 0);
        }
        return this.patterns;
    }

    private Integer getValueForItemId(int itemID) {
        String identifier = this.mapItemIdIdentifier.get(itemID);
        int index = identifier.indexOf("-");
        return Integer.valueOf(identifier.substring(0, index));
    }

    private Integer getDimensionForItemId(int value) {
        String identifier = this.mapItemIdIdentifier.get(value);
        int index = identifier.indexOf(45);
        return Integer.valueOf(identifier.substring(index + 1, identifier.length()));
    }

    private int convertDimensionValueToItemId(int indexDimension, Integer value) {
        Integer itemId = this.mapIdentifierItemId.get("" + value + "-" + indexDimension);
        if (itemId == null) {
            itemId = this.lastUniqueItemIdGiven++;
            StringBuilder identifier = new StringBuilder();
            identifier.append(value);
            identifier.append('-');
            identifier.append(indexDimension);
            this.mapIdentifierItemId.put(identifier.toString(), itemId);
            this.mapItemIdIdentifier.put(itemId, identifier.toString());
        }
        return itemId;
    }

    private List<Integer> convertPatternToItemset(MDPattern pattern) {
        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
        for (int i = 0; i < pattern.values.size(); ++i) {
            itemset2.add(this.convertDimensionValueToItemId(i, pattern.values.get(i)));
        }
        return itemset2;
    }

    private MDPattern convertItemsetToPattern(ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset itemset2) {
        MDPattern mdpattern = new MDPattern(0);
        for (int i = 0; i < this.dimensionsCount; ++i) {
            for (int j = 0; j < itemset2.size(); ++j) {
                int dimension = this.getDimensionForItemId(itemset2.get(j));
                int value = this.getValueForItemId(itemset2.get(j));
                if (dimension != i) continue;
                mdpattern.addInteger(value);
            }
            if (mdpattern.size() != i) continue;
            mdpattern.addWildCard();
        }
        mdpattern.setPatternsIDList(itemset2.getTransactionsIds());
        return mdpattern;
    }

    private MDPattern convertItemsetCharmToPattern(Itemset itemset2) {
        MDPattern mdpattern = new MDPattern(0);
        for (int i = 0; i < this.dimensionsCount; ++i) {
            for (int j = 0; j < itemset2.size(); ++j) {
                int[] objects = itemset2.getItems();
                int dimension = this.getDimensionForItemId(objects[j]);
                int value = this.getValueForItemId(objects[j]);
                if (dimension != i) continue;
                mdpattern.addInteger(value);
            }
            if (mdpattern.size() != i) continue;
            mdpattern.addWildCard();
        }
        HashSet<Integer> tidset2 = new HashSet<Integer>();
        int tid = itemset2.getTransactionsIds().nextSetBit(0);
        while (tid >= 0) {
            tidset2.add(tid);
            tid = itemset2.getTransactionsIds().nextSetBit(tid + 1);
        }
        mdpattern.setPatternsIDList(tidset2);
        return mdpattern;
    }

    public void printStats(int databaseSize) {
        System.out.println("=============  DIM - STATS =============");
        System.out.println(" Frequent patterns count : " + this.patterns.size());
        this.patterns.printPatterns(databaseSize);
        System.out.println("===================================================");
    }
}

