/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemValued;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPatternsDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MDSequenceDatabase {
    private final List<MDSequence> sequences = new ArrayList<MDSequence>();
    private final SequenceDatabase sequenceDatabase = new SequenceDatabase();
    private final MDPatternsDatabase patternDatabase = new MDPatternsDatabase();
    private final Set<ItemSimple> itemIDs = new HashSet<ItemSimple>();
    private int sequenceNumber = 0;

    public int getItemCount() {
        return this.itemIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.processMDSequence(thisLine.split(" "));
            }
        }
    }

    private void processMDSequence(String[] tokens) {
        int i;
        MDPattern mdpattern = new MDPattern(this.sequenceNumber);
        for (i = 0; i < tokens.length && !tokens[i].equals("-3"); ++i) {
            if (tokens[i].equals("*")) {
                mdpattern.addInteger(9999);
                continue;
            }
            mdpattern.addInteger(Integer.valueOf(tokens[i]));
        }
        Sequence sequence = new Sequence(this.sequenceNumber);
        Itemset itemset2 = new Itemset();
        ++i;
        while (i < tokens.length) {
            if (tokens[i].codePointAt(0) == 60) {
                String value = tokens[i].substring(1, tokens[i].length() - 1);
                itemset2.setTimestamp(Long.parseLong(value));
            } else if (tokens[i].equals("-1")) {
                sequence.addItemset(itemset2);
                itemset2 = new Itemset();
            } else if (tokens[i].equals("-2")) {
                MDSequence mdsequence = new MDSequence(this.sequenceNumber, mdpattern, sequence);
                this.sequences.add(mdsequence);
                this.sequenceDatabase.addSequence(sequence);
                this.patternDatabase.addMDPattern(mdpattern);
                ++this.sequenceNumber;
            } else {
                int indexLeftParenthesis = tokens[i].indexOf("(");
                int value = 0;
                if (indexLeftParenthesis != -1) {
                    int indexRightParenthesis = tokens[i].indexOf(")");
                    value = Integer.parseInt(tokens[i].substring(indexLeftParenthesis + 1, indexRightParenthesis));
                    tokens[i] = tokens[i].substring(0, indexLeftParenthesis);
                    ItemValued item = new ItemValued(Integer.parseInt(tokens[i]), value);
                    itemset2.addItem(item);
                } else {
                    ItemSimple item = new ItemSimple(Integer.parseInt(tokens[i]));
                    itemset2.addItem(item);
                }
            }
            ++i;
        }
    }

    public void addSequence(MDSequence sequence) {
        this.sequences.add(sequence);
        this.sequenceDatabase.addSequence(sequence.getSequence());
        this.patternDatabase.addMDPattern(sequence.getMdpattern());
    }

    public void printDatabase() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder out = new StringBuilder("============  MD Sequence Database ==========\n");
        for (MDSequence sequence : this.sequences) {
            out.append(sequence.toString() + "\n");
        }
        return out.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<MDSequence> getSequences() {
        return this.sequences;
    }

    public MDSequence get(int index) {
        return this.sequences.get(index);
    }

    public Set<ItemSimple> getItemIDs() {
        return this.itemIDs;
    }

    public SequenceDatabase getSequenceDatabase() {
        return this.sequenceDatabase;
    }

    public MDPatternsDatabase getPatternDatabase() {
        return this.patternDatabase;
    }
}

