/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.occur;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AlgoOccur {
    long startTime;
    long endTime;
    BufferedWriter writer = null;
    SequenceDatabase sequenceDatabase;

    public void runAlgorithm(String inputFile, String patternFile, String outputFilePath) throws IOException {
        this.startTime = System.currentTimeMillis();
        this.sequenceDatabase = new SequenceDatabase();
        this.sequenceDatabase.loadFile(inputFile);
        this.writer = outputFilePath == null ? null : new BufferedWriter(new FileWriter(outputFilePath));
        this.processPatterns(patternFile);
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void processPatterns(String patternFile) throws IOException {
        String thisLine;
        BufferedReader myInput = null;
        FileInputStream fin = new FileInputStream(new File(patternFile));
        myInput = new BufferedReader(new InputStreamReader(fin));
        while ((thisLine = myInput.readLine()) != null) {
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
            int posFirstCharacterSUP = thisLine.indexOf(35);
            String sequenceText = thisLine.substring(0, posFirstCharacterSUP - 1);
            int posFirstCharacterSIDLine = thisLine.indexOf("#SID");
            String sidListString = thisLine.substring(posFirstCharacterSIDLine + 6);
            String supText = thisLine.substring(posFirstCharacterSUP, posFirstCharacterSIDLine - 1);
            String[] sidsSplit = sidListString.split(" ");
            int[] sids = new int[sidsSplit.length];
            for (int i = 0; i < sidsSplit.length; ++i) {
                sids[i] = Integer.parseInt(sidsSplit[i]);
            }
            String[] itemSplit = sequenceText.split(" ");
            int[] pattern = new int[itemSplit.length];
            for (int i = 0; i < itemSplit.length; ++i) {
                pattern[i] = Integer.parseInt(itemSplit[i]);
            }
            this.writer.append(sequenceText);
            this.writer.append(' ');
            this.writer.append(supText);
            this.writer.append(" #SIDOCC:");
            this.findOccurrences(sids, pattern);
            this.writer.newLine();
        }
        myInput.close();
    }

    private void findOccurrences(int[] sids, int[] pattern) throws IOException {
        for (int sid : sids) {
            ArrayList<String> occurrences = new ArrayList<String>();
            int[] sequence = this.sequenceDatabase.getSequences().get(sid);
            this.findOccurrencesHelper(pattern, sequence, 0, 0, "", 0, occurrences);
            this.writer.append(" " + sid);
            for (int i = 0; i < occurrences.size(); ++i) {
                this.writer.append('[');
                this.writer.append((CharSequence)occurrences.get(i));
                this.writer.append(']');
                if (i == occurrences.size() - 1) continue;
                this.writer.append(' ');
            }
        }
    }

    private void findOccurrencesHelper(int[] pattern, int[] sequence, int posPattern, int posSequence, String occurrence, int posItemsetSequence, List<String> listOccurrences) {
        int patternResetPosition = posPattern;
        do {
            if (pattern[posPattern] == sequence[posSequence]) {
                if (pattern[posPattern] == -1) {
                    String newOccurrence = occurrence.length() == 0 ? occurrence + posItemsetSequence : occurrence + " " + posItemsetSequence;
                    if (posPattern == pattern.length - 1) {
                        listOccurrences.add(newOccurrence);
                    } else {
                        this.findOccurrencesHelper(pattern, sequence, posPattern + 1, posSequence + 1, newOccurrence, posItemsetSequence + 1, listOccurrences);
                    }
                    ++posItemsetSequence;
                    posPattern = patternResetPosition;
                    continue;
                }
                ++posPattern;
                continue;
            }
            if (sequence[posSequence] != -1) continue;
            posPattern = patternResetPosition;
            ++posItemsetSequence;
        } while (++posSequence < sequence.length);
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Occur 2.37 - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms");
        r.append(System.lineSeparator());
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(System.lineSeparator());
        r.append("===================================================");
        r.append(System.lineSeparator());
        System.out.println(r.toString());
    }
}

