/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.phuspm;

import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.Element;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.SequenceList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoPHUSPM {
    int maxMemory = 0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    public static int numberOfHUSP = 0;
    public static int numberOfCandidates = 0;
    BufferedWriter writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility, float minProbability) throws IOException {
        String thisLine;
        this.maxMemory = 0;
        this.startTimestamp = System.currentTimeMillis();
        numberOfHUSP = 0;
        numberOfCandidates = 0;
        this.writer = new BufferedWriter(new FileWriter(output));
        BufferedReader myInput = null;
        HashMap<Integer, Integer> RSU = new HashMap<Integer, Integer>();
        HashMap<Integer, Float> Probability = new HashMap<Integer, Float>();
        HashMap<Integer, SequenceList> sequenceListMap = new HashMap<Integer, SequenceList>();
        HashMap<Integer, Integer> orderSWU = new HashMap<Integer, Integer>();
        HashMap<Integer, Float> orderSWP = new HashMap<Integer, Float>();
        ArrayList<List<Itemset>> revisedDatabase = new ArrayList<List<Itemset>>();
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            thisLine = null;
            while ((thisLine = myInput.readLine()) != null) {
                HashSet<Integer> set = new HashSet<Integer>();
                String[] arry = thisLine.split(" -1 ");
                int lineUtility = Integer.parseInt(arry[arry.length - 2]);
                float lineProbability = Float.parseFloat(arry[arry.length - 1]);
                for (int i = 0; i < arry.length - 2; ++i) {
                    String[] itemset2 = arry[i].split(" , ");
                    for (int j = 0; j < itemset2.length; ++j) {
                        String[] itemProperty = itemset2[j].split(" ");
                        int item = Integer.parseInt(itemProperty[0]);
                        set.add(item);
                    }
                }
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    int item = (Integer)it.next();
                    if (!RSU.containsKey(item)) {
                        RSU.put(item, lineUtility);
                    } else {
                        RSU.put(item, (Integer)RSU.get(item) + lineUtility);
                    }
                    if (!Probability.containsKey(item)) {
                        Probability.put(item, Float.valueOf(lineProbability));
                        continue;
                    }
                    Probability.put(item, Float.valueOf(((Float)Probability.get(item)).floatValue() + lineProbability));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            thisLine = null;
            int order = 0;
            while ((thisLine = myInput.readLine()) != null) {
                ArrayList<Itemset> sequnce = new ArrayList<Itemset>();
                String[] arry = thisLine.split(" -1 ");
                int lineSWU = Integer.parseInt(arry[arry.length - 2]);
                float lineSWP = Float.parseFloat(arry[arry.length - 1]);
                for (int i = 0; i < arry.length - 2; ++i) {
                    Itemset sitemset = new Itemset();
                    String[] itemset3 = arry[i].split(" , ");
                    for (int j = 0; j < itemset3.length; ++j) {
                        String[] itemProperty = itemset3[j].split(" ");
                        int item = Integer.parseInt(itemProperty[0]);
                        int utility = Integer.parseInt(itemProperty[1]);
                        if ((Integer)RSU.get(item) >= minUtility && ((Float)Probability.get(item)).floatValue() >= minProbability) {
                            Item sitem = new Item();
                            sitem.item = item;
                            sitem.utility = utility;
                            sitemset.Itemset.add(sitem);
                            continue;
                        }
                        lineSWU -= utility;
                    }
                    if (sitemset.Itemset.isEmpty()) continue;
                    sequnce.add(sitemset);
                }
                if (sequnce.isEmpty()) continue;
                revisedDatabase.add(sequnce);
                orderSWU.put(order, lineSWU);
                orderSWP.put(order, Float.valueOf(lineSWP));
                ++order;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        for (int i = 0; i < revisedDatabase.size(); ++i) {
            int lineSWU = (Integer)orderSWU.get(i);
            float lineProbability = ((Float)orderSWP.get(i)).floatValue();
            int restUtility = lineSWU;
            for (int j = 0; j < ((List)revisedDatabase.get(i)).size(); ++j) {
                for (int k = 0; k < ((Itemset)((List)revisedDatabase.get((int)i)).get((int)j)).Itemset.size(); ++k) {
                    int item = ((Itemset)((List)revisedDatabase.get((int)i)).get((int)j)).Itemset.get((int)k).item;
                    int utility = ((Itemset)((List)revisedDatabase.get((int)i)).get((int)j)).Itemset.get((int)k).utility;
                    Element element = new Element(i, j, utility, lineProbability, restUtility -= utility);
                    if (sequenceListMap.containsKey(item)) {
                        ((SequenceList)sequenceListMap.get(item)).addElement(element);
                        continue;
                    }
                    SequenceList Seq = new SequenceList();
                    ArrayList<Integer> itemSet = new ArrayList<Integer>();
                    itemSet.add(item);
                    Seq.addItemset(itemSet);
                    Seq.addElement(element);
                    sequenceListMap.put(item, Seq);
                }
            }
        }
        ArrayList oneSequenceList = new ArrayList(sequenceListMap.values());
        for (int i = 0; i < oneSequenceList.size(); ++i) {
            ((SequenceList)oneSequenceList.get(i)).calculate();
            if (((SequenceList)oneSequenceList.get((int)i)).sumSWU >= minUtility && !(((SequenceList)oneSequenceList.get((int)i)).sumProbability < minProbability)) continue;
            oneSequenceList.remove(i);
            --i;
        }
        Collections.sort(oneSequenceList, new Comparator<SequenceList>(){

            @Override
            public int compare(SequenceList mc1, SequenceList mc2) {
                return mc1.itemsets.get(0).get(0) - mc2.itemsets.get(0).get(0);
            }
        });
        for (SequenceList Seq : oneSequenceList) {
            this.AlgoPHUSPM(Seq, revisedDatabase, minUtility, minProbability);
        }
        numberOfCandidates += oneSequenceList.size();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void AlgoPHUSPM(SequenceList Seq, List<List<Itemset>> revisedDatabase, int minUtility, float minProbability) throws IOException {
        ++numberOfCandidates;
        if (Seq.sumUtility >= minUtility && Seq.sumProbability >= minProbability) {
            ++numberOfHUSP;
            this.writeOut(Seq);
        }
        MemoryLogger.getInstance().checkMemory();
        ArrayList<SequenceList> nextGeneration = new ArrayList<SequenceList>();
        HashMap<Integer, SequenceList> itemExtend = new HashMap<Integer, SequenceList>();
        HashMap<Integer, SequenceList> itemsetExtend = new HashMap<Integer, SequenceList>();
        for (Element element : Seq.elements) {
            int item;
            int SID = element.SID;
            int location = element.location;
            int preUtility = 0;
            int i = 0;
            for (i = 0; i < revisedDatabase.get((int)SID).get((int)location).Itemset.size(); ++i) {
                item = revisedDatabase.get((int)SID).get((int)location).Itemset.get((int)i).item;
                if (item != Seq.itemsets.get(Seq.itemsets.size() - 1).get(Seq.itemsets.get(Seq.itemsets.size() - 1).size() - 1)) continue;
                ++i;
                break;
            }
            while (i < revisedDatabase.get((int)SID).get((int)location).Itemset.size()) {
                item = revisedDatabase.get((int)SID).get((int)location).Itemset.get((int)i).item;
                int utility = revisedDatabase.get((int)SID).get((int)location).Itemset.get((int)i).utility;
                Element newElement = new Element(SID, location, element.utility + utility, element.probability, element.restUtility - (preUtility += utility));
                if (!itemExtend.containsKey(item)) {
                    SequenceList newlist = new SequenceList();
                    newlist.itemsets.addAll(Seq.itemsets);
                    ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                    itemset2.addAll((Collection)Seq.itemsets.get(Seq.itemsets.size() - 1));
                    itemset2.add(item);
                    newlist.itemsets.remove(newlist.itemsets.size() - 1);
                    newlist.itemsets.add(itemset2);
                    newlist.addElement(newElement);
                    itemExtend.put(item, newlist);
                } else {
                    ((SequenceList)itemExtend.get(item)).addElement(newElement);
                }
                ++i;
            }
            for (int j = element.location + 1; j < revisedDatabase.get(SID).size(); ++j) {
                for (int k = 0; k < revisedDatabase.get((int)SID).get((int)j).Itemset.size(); ++k) {
                    int item2 = revisedDatabase.get((int)SID).get((int)j).Itemset.get((int)k).item;
                    int utility = revisedDatabase.get((int)SID).get((int)j).Itemset.get((int)k).utility;
                    Element newElement = new Element(SID, j, element.utility + utility, element.probability, element.restUtility - (preUtility += utility));
                    if (!itemsetExtend.containsKey(item2)) {
                        SequenceList newlist = new SequenceList();
                        newlist.itemsets.addAll(Seq.itemsets);
                        ArrayList<Integer> itemset3 = new ArrayList<Integer>();
                        itemset3.add(item2);
                        newlist.itemsets.add(itemset3);
                        newlist.addElement(newElement);
                        itemsetExtend.put(item2, newlist);
                        continue;
                    }
                    ((SequenceList)itemsetExtend.get(item2)).addElement(newElement);
                }
            }
        }
        for (Map.Entry entry : itemExtend.entrySet()) {
            ((SequenceList)entry.getValue()).calculate();
            if (((SequenceList)entry.getValue()).sumSWU < minUtility || !(((SequenceList)entry.getValue()).sumProbability >= minProbability)) continue;
            nextGeneration.add((SequenceList)entry.getValue());
        }
        for (Map.Entry entry : itemsetExtend.entrySet()) {
            ((SequenceList)entry.getValue()).calculate();
            if (((SequenceList)entry.getValue()).sumSWU < minUtility || !(((SequenceList)entry.getValue()).sumProbability >= minProbability)) continue;
            nextGeneration.add((SequenceList)entry.getValue());
        }
        for (SequenceList nextlist : nextGeneration) {
            this.AlgoPHUSPM(nextlist, revisedDatabase, minUtility, minProbability);
        }
    }

    private void writeOut(SequenceList sequence) throws IOException {
        for (List<Integer> items : sequence.itemsets) {
            for (int item : items) {
                this.writer.write(item + " ");
            }
            this.writer.write("-1 ");
        }
        this.writer.write("#UITL: ");
        this.writer.write(Integer.toString(sequence.sumUtility));
        this.writer.write(" #SP: ");
        this.writer.write(Float.toString(sequence.sumProbability));
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=======  THE RESULT OF THE ALGORITHM - STATS ============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) / 1000L + " s");
        System.out.println(" Candidates count: " + numberOfCandidates);
        System.out.println(" HUSPs count: " + numberOfHUSP);
        System.out.println(" Max memory: " + MemoryLogger.getInstance().getMaxMemory() + "  MB");
        System.out.println("======================================================");
    }
}

