/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug.SequentialPatterns;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPrefixSpan {
    long startTime;
    long endTime;
    int patternCount;
    private int minsuppAbsolute;
    BufferedWriter writer = null;
    private SequentialPatterns patterns = null;
    private int maximumPatternLength = Integer.MAX_VALUE;
    boolean showSequenceIdentifiers = false;
    final int BUFFERS_SIZE = 2000;
    private int[] patternBuffer = new int[2000];
    int sequenceCount = 0;
    SequenceDatabase sequenceDatabase;
    boolean containsItemsetsWithMultipleItems = false;

    public SequentialPatterns runAlgorithm(String inputFile, double minsupRelative, String outputFilePath) throws IOException {
        this.startTime = System.currentTimeMillis();
        this.sequenceDatabase = new SequenceDatabase();
        this.sequenceDatabase.loadFile(inputFile);
        this.sequenceCount = this.sequenceDatabase.size();
        this.minsuppAbsolute = (int)Math.ceil(minsupRelative * (double)this.sequenceCount);
        if (this.minsuppAbsolute == 0) {
            this.minsuppAbsolute = 1;
        }
        this.prefixSpan(this.sequenceDatabase, outputFilePath);
        this.sequenceDatabase = null;
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    public SequentialPatterns runAlgorithm(String inputFile, String outputFilePath, int minsup) throws IOException {
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsuppAbsolute = minsup;
        this.startTime = System.currentTimeMillis();
        this.sequenceDatabase = new SequenceDatabase();
        this.sequenceDatabase.loadFile(inputFile);
        this.prefixSpan(this.sequenceDatabase, outputFilePath);
        this.sequenceDatabase = null;
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private void prefixSpan(SequenceDatabase sequenceDatabase, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.patterns = new SequentialPatterns("FREQUENT SEQUENTIAL PATTERNS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        this.sequenceCount = sequenceDatabase.size();
        Map<Integer, List<Integer>> mapSequenceID = this.findSequencesContainingItems();
        if (this.containsItemsetsWithMultipleItems) {
            this.prefixspanWithMultipleItems(mapSequenceID);
        } else {
            this.prefixspanWithSingleItems(mapSequenceID);
        }
    }

    private void prefixspanWithSingleItems(Map<Integer, List<Integer>> mapSequenceID) throws IOException {
        for (int i = 0; i < this.sequenceDatabase.size(); ++i) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int currentPosition = 0;
            for (int j = 0; j < sequence.length; ++j) {
                int token = sequence[j];
                if (token > 0) {
                    boolean isFrequent;
                    boolean bl = isFrequent = mapSequenceID.get(token).size() >= this.minsuppAbsolute;
                    if (!isFrequent) continue;
                    sequence[currentPosition] = token;
                    ++currentPosition;
                    continue;
                }
                if (token != -2) continue;
                if (currentPosition > 0) {
                    sequence[currentPosition] = -2;
                    int[] newSequence = new int[currentPosition + 1];
                    System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                    this.sequenceDatabase.getSequences().set(i, newSequence);
                    continue;
                }
                this.sequenceDatabase.getSequences().set(i, null);
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : mapSequenceID.entrySet()) {
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute) continue;
            int item = entry.getKey();
            this.savePattern(item, support, entry.getValue());
            if (this.maximumPatternLength <= 1) continue;
            this.patternBuffer[0] = item;
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseSingleItems(item, entry.getValue());
            this.recursionSingleItems(projectedDatabase, 2, 0);
        }
    }

    private void prefixspanWithMultipleItems(Map<Integer, List<Integer>> mapSequenceID) throws IOException {
        for (int i = 0; i < this.sequenceDatabase.size(); ++i) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int currentPosition = 0;
            int currentItemsetItemCount = 0;
            for (int j = 0; j < sequence.length; ++j) {
                int token = sequence[j];
                if (token > 0) {
                    boolean isFrequent;
                    boolean bl = isFrequent = mapSequenceID.get(token).size() >= this.minsuppAbsolute;
                    if (!isFrequent) continue;
                    sequence[currentPosition] = token;
                    ++currentPosition;
                    ++currentItemsetItemCount;
                    continue;
                }
                if (token == -1) {
                    if (currentItemsetItemCount <= 0) continue;
                    sequence[currentPosition] = -1;
                    ++currentPosition;
                    currentItemsetItemCount = 0;
                    continue;
                }
                if (token != -2) continue;
                if (currentPosition > 0) {
                    sequence[currentPosition] = -2;
                    int[] newSequence = new int[currentPosition + 1];
                    System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                    this.sequenceDatabase.getSequences().set(i, newSequence);
                    continue;
                }
                this.sequenceDatabase.getSequences().set(i, null);
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : mapSequenceID.entrySet()) {
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute) continue;
            int item = entry.getKey();
            this.savePattern(item, support, entry.getValue());
            if (this.maximumPatternLength <= 1) continue;
            this.patternBuffer[0] = item;
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseFirstTimeMultipleItems(item, entry.getValue());
            this.recursion(this.patternBuffer, projectedDatabase, 2, 0);
        }
    }

    private void savePattern(int item, int support, List<Integer> sequenceIDs) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuilder r = new StringBuilder();
            r.append(item);
            r.append(" -1 #SUP: ");
            r.append(support);
            if (this.showSequenceIdentifiers) {
                r.append(" #SID: ");
                for (Integer sid : sequenceIDs) {
                    r.append(sid);
                    r.append(" ");
                }
            }
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            SequentialPattern pattern = new SequentialPattern();
            pattern.addItemset(new Itemset(item));
            pattern.setSequenceIDs(sequenceIDs);
            this.patterns.addSequence(pattern, 1);
        }
    }

    private void savePattern(int lastBufferPosition, List<PseudoSequence> pseudoSequences) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuilder r = new StringBuilder();
            for (int i = 0; i <= lastBufferPosition; ++i) {
                r.append(this.patternBuffer[i]);
                r.append(" ");
            }
            if (!this.containsItemsetsWithMultipleItems) {
                r.append("-1 ");
            }
            r.append("#SUP: ");
            r.append(pseudoSequences.size());
            if (this.showSequenceIdentifiers) {
                r.append(" #SID: ");
                for (PseudoSequence sequence : pseudoSequences) {
                    r.append(sequence.sequenceID);
                    r.append(" ");
                }
            }
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            SequentialPattern pattern = new SequentialPattern();
            int itemsetCount = 0;
            Itemset currentItemset = new Itemset();
            for (int i = 0; i <= lastBufferPosition; ++i) {
                int token = this.patternBuffer[i];
                if (token > 0) {
                    currentItemset.addItem(token);
                    continue;
                }
                if (token != -1) continue;
                pattern.addItemset(currentItemset);
                currentItemset = new Itemset();
                ++itemsetCount;
            }
            pattern.addItemset(currentItemset);
            ++itemsetCount;
            ArrayList<Integer> sequencesIDs = new ArrayList<Integer>(pseudoSequences.size());
            for (int i = 0; i < pseudoSequences.size(); ++i) {
                sequencesIDs.add(pseudoSequences.get((int)i).sequenceID);
            }
            pattern.setSequenceIDs(sequencesIDs);
            this.patterns.addSequence(pattern, itemsetCount);
        }
    }

    private Map<Integer, List<Integer>> findSequencesContainingItems() {
        HashMap<Integer, List<Integer>> mapSequenceID = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < this.sequenceDatabase.size(); ++i) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int itemCountInCurrentItemset = 0;
            for (int token : sequence) {
                if (token > 0) {
                    ArrayList<Integer> sequenceIDs = (ArrayList<Integer>)mapSequenceID.get(token);
                    if (sequenceIDs == null) {
                        sequenceIDs = new ArrayList<Integer>();
                        mapSequenceID.put(token, sequenceIDs);
                    }
                    if (sequenceIDs.size() == 0 || (Integer)sequenceIDs.get(sequenceIDs.size() - 1) != i) {
                        sequenceIDs.add(i);
                    }
                    if (++itemCountInCurrentItemset <= 1) continue;
                    this.containsItemsetsWithMultipleItems = true;
                    continue;
                }
                if (token != -1) continue;
                itemCountInCurrentItemset = 0;
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseSingleItems(int item, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token == item) {
                    if (sequence[j + 1] == -2) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
        }
        return projectedDatabase;
    }

    private List<PseudoSequence> buildProjectedDatabaseFirstTimeMultipleItems(int item, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token == item) {
                    boolean isEndOfSequence = sequence[j + 1] == -1 && sequence[j + 2] == -2;
                    if (isEndOfSequence) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
        }
        return projectedDatabase;
    }

    private void recursionSingleItems(List<PseudoSequence> database, int k, int lastBufferPosition) throws IOException {
        Map<Integer, List<PseudoSequence>> itemsPseudoSequences = this.findAllFrequentPairsSingleItems(database, lastBufferPosition);
        database = null;
        for (Map.Entry<Integer, List<PseudoSequence>> entry : itemsPseudoSequences.entrySet()) {
            if (entry.getValue().size() < this.minsuppAbsolute) continue;
            this.patternBuffer[lastBufferPosition + 1] = -1;
            this.patternBuffer[lastBufferPosition + 2] = entry.getKey();
            this.savePattern(lastBufferPosition + 2, entry.getValue());
            if (k >= this.maximumPatternLength) continue;
            this.recursionSingleItems(entry.getValue(), k + 1, lastBufferPosition + 2);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void recursion(int[] patternBuffer, List<PseudoSequence> database, int k, int lastBufferPosition) throws IOException {
        int newBuferPosition;
        Pair pair;
        MapFrequentPairs mapsPairs = this.findAllFrequentPairs(database, lastBufferPosition);
        database = null;
        for (Map.Entry<Pair, Pair> entry : mapsPairs.mapPairsInPostfix.entrySet()) {
            pair = entry.getKey();
            if (pair.getCount() < this.minsuppAbsolute) continue;
            newBuferPosition = lastBufferPosition;
            patternBuffer[++newBuferPosition] = pair.item;
            this.savePattern(newBuferPosition, pair.getPseudoSequences());
            if (k >= this.maximumPatternLength) continue;
            this.recursion(patternBuffer, pair.getPseudoSequences(), k + 1, newBuferPosition);
        }
        for (Map.Entry<Pair, Pair> entry : mapsPairs.mapPairs.entrySet()) {
            pair = entry.getKey();
            if (pair.getCount() < this.minsuppAbsolute) continue;
            newBuferPosition = lastBufferPosition;
            patternBuffer[++newBuferPosition] = -1;
            patternBuffer[++newBuferPosition] = pair.item;
            this.savePattern(newBuferPosition, pair.getPseudoSequences());
            if (k >= this.maximumPatternLength) continue;
            this.recursion(patternBuffer, pair.getPseudoSequences(), k + 1, newBuferPosition);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    protected Map<Integer, List<PseudoSequence>> findAllFrequentPairsSingleItems(List<PseudoSequence> sequences, int lastBufferPosition) {
        HashMap<Integer, List<PseudoSequence>> mapItemsPseudoSequences = new HashMap<Integer, List<PseudoSequence>>();
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int i = pseudoSequence.indexFirstItem;
            while (sequence[i] != -2) {
                int token = sequence[i];
                if (token > 0) {
                    ArrayList<PseudoSequence> listSequences = (ArrayList<PseudoSequence>)mapItemsPseudoSequences.get(token);
                    if (listSequences == null) {
                        listSequences = new ArrayList<PseudoSequence>();
                        mapItemsPseudoSequences.put(token, listSequences);
                    }
                    boolean ok = true;
                    if (listSequences.size() > 0) {
                        boolean bl = ok = ((PseudoSequence)listSequences.get((int)(listSequences.size() - 1))).sequenceID != sequenceID;
                    }
                    if (ok) {
                        listSequences.add(new PseudoSequence(sequenceID, i + 1));
                    }
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapItemsPseudoSequences;
    }

    protected MapFrequentPairs findAllFrequentPairs(List<PseudoSequence> sequences, int lastBufferPosition) {
        MapFrequentPairs mapsPairs = new MapFrequentPairs();
        int firstPositionOfLastItemsetInBuffer = lastBufferPosition;
        while (lastBufferPosition > 0) {
            if (--firstPositionOfLastItemsetInBuffer >= 0 && this.patternBuffer[firstPositionOfLastItemsetInBuffer] != -1) continue;
            ++firstPositionOfLastItemsetInBuffer;
            break;
        }
        int positionToBeMatched = firstPositionOfLastItemsetInBuffer;
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int previousItem = sequence[pseudoSequence.indexFirstItem - 1];
            boolean currentItemsetIsPostfix = previousItem != -1;
            boolean isFirstItemset = true;
            int i = pseudoSequence.indexFirstItem;
            while (sequence[i] != -2) {
                int token = sequence[i];
                if (token > 0) {
                    Pair pair = new Pair(token);
                    Pair oldPair = currentItemsetIsPostfix ? mapsPairs.mapPairsInPostfix.get(pair) : mapsPairs.mapPairs.get(pair);
                    if (oldPair == null) {
                        if (currentItemsetIsPostfix) {
                            mapsPairs.mapPairsInPostfix.put(pair, pair);
                        } else {
                            mapsPairs.mapPairs.put(pair, pair);
                        }
                    } else {
                        pair = oldPair;
                    }
                    boolean ok = true;
                    if (pair.getPseudoSequences().size() > 0) {
                        boolean bl = ok = pair.getPseudoSequences().get((int)(pair.getPseudoSequences().size() - 1)).sequenceID != sequenceID;
                    }
                    if (ok) {
                        pair.getPseudoSequences().add(new PseudoSequence(sequenceID, i + 1));
                    }
                    if (currentItemsetIsPostfix && !isFirstItemset) {
                        pair = new Pair(token);
                        oldPair = mapsPairs.mapPairs.get(pair);
                        if (oldPair == null) {
                            mapsPairs.mapPairs.put(pair, pair);
                        } else {
                            pair = oldPair;
                        }
                        ok = true;
                        if (pair.getPseudoSequences().size() > 0) {
                            boolean bl = ok = pair.getPseudoSequences().get((int)(pair.getPseudoSequences().size() - 1)).sequenceID != sequenceID;
                        }
                        if (ok) {
                            pair.getPseudoSequences().add(new PseudoSequence(sequenceID, i + 1));
                        }
                    }
                    if (!currentItemsetIsPostfix && this.patternBuffer[positionToBeMatched] == token && ++positionToBeMatched > lastBufferPosition) {
                        currentItemsetIsPostfix = true;
                    }
                } else if (token == -1) {
                    isFirstItemset = false;
                    currentItemsetIsPostfix = false;
                    positionToBeMatched = firstPositionOfLastItemsetInBuffer;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapsPairs;
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  PREFIXSPAN 0.99-2016 - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append(" minsup = " + this.minsuppAbsolute + " sequences.");
        r.append('\n');
        r.append(" Pattern count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append("===================================================\n");
        if (this.patterns != null) {
            this.patterns.printFrequentPatterns(this.sequenceCount, this.showSequenceIdentifiers);
        }
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setShowSequenceIdentifiers(boolean showSequenceIdentifiers) {
        this.showSequenceIdentifiers = showSequenceIdentifiers;
    }

    public class MapFrequentPairs {
        public final Map<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        public final Map<Pair, Pair> mapPairsInPostfix = new HashMap<Pair, Pair>();
    }
}

