/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SequenceDatabase {
    List<int[]> sequences = new ArrayList<int[]>();
    long itemOccurrenceCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        this.itemOccurrenceCount = 0L;
        this.sequences = new ArrayList<int[]>();
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] tokens = thisLine.split(" ");
                int[] sequence = new int[tokens.length];
                for (int j = 0; j < tokens.length; ++j) {
                    sequence[j] = Integer.parseInt(tokens[j]);
                }
                this.sequences.add(sequence);
            }
        }
    }

    public void print() {
        System.out.println("============  SEQUENCE DATABASE ==========");
        System.out.println(this.toString());
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        double meansize = (float)this.itemOccurrenceCount / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.sequences.size(); ++i) {
            buffer.append(i + ":  ");
            int[] sequence = this.sequences.get(i);
            boolean startingANewItemset = true;
            for (int token : sequence) {
                if (token >= 0) {
                    if (startingANewItemset) {
                        startingANewItemset = false;
                        buffer.append("(");
                    } else {
                        buffer.append(" ");
                    }
                    buffer.append(token);
                    ++this.itemOccurrenceCount;
                    continue;
                }
                if (token == -1) {
                    buffer.append(")");
                    startingANewItemset = true;
                    continue;
                }
                if (token == -2) break;
            }
            buffer.append(System.lineSeparator());
        }
        return buffer.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<int[]> getSequences() {
        return this.sequences;
    }
}

