/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prosecco;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPatterns;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AlgoGetFS {
    SequenceDatabase sequenceDatabase;
    private int minsuppAbsolute;
    private boolean isUsingFrequentItems = false;
    boolean showSequenceIdentifiers = false;
    boolean containsItemsetsWithMultipleItems = false;
    protected Map<Integer, List<Integer>> mapSequenceID;
    private SequentialPatterns patterns = null;
    private int maximumPatternLength = 1000;
    final int BUFFERS_SIZE = 2000;
    private int[] patternBuffer = new int[2000];
    int sequenceCount = 0;

    public void reset() {
        this.containsItemsetsWithMultipleItems = false;
        this.patterns = null;
        this.mapSequenceID = null;
        this.minsuppAbsolute = 0;
    }

    public SequentialPatterns getFS(SequenceDatabase sequenceDatabase, int minSup) throws IOException {
        this.patterns = new SequentialPatterns("FREQUENT SEQUENTIAL PATTERNS");
        if (this.mapSequenceID != null) {
            this.isUsingFrequentItems = true;
        }
        this.sequenceDatabase = sequenceDatabase;
        this.sequenceCount = sequenceDatabase.size();
        this.minsuppAbsolute = minSup;
        if (this.isUsingFrequentItems) {
            this.findSequencesContainingItems();
        } else {
            this.mapSequenceID = this.findSequencesContainingItems();
            for (Integer key : new HashSet<Integer>(this.mapSequenceID.keySet())) {
                if (this.mapSequenceID.get(key).size() >= this.minsuppAbsolute) continue;
                this.mapSequenceID.remove(key);
            }
        }
        if (this.containsItemsetsWithMultipleItems) {
            this.prefixspanWithMultipleItems(this.mapSequenceID);
        } else {
            this.prefixspanWithSingleItems(this.mapSequenceID);
        }
        return this.patterns;
    }

    private void prefixspanWithSingleItems(Map<Integer, List<Integer>> mapSequenceID) throws IOException {
        for (int i = 0; i < this.sequenceDatabase.size(); ++i) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int currentPosition = 0;
            for (int j = 0; j < sequence.length; ++j) {
                int token = sequence[j];
                if (token > 0) {
                    boolean isFrequent = mapSequenceID.containsKey(token);
                    if (!isFrequent) continue;
                    sequence[currentPosition] = token;
                    ++currentPosition;
                    continue;
                }
                if (token != -2) continue;
                if (currentPosition > 0) {
                    sequence[currentPosition] = -2;
                    int[] newSequence = new int[currentPosition + 1];
                    System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                    this.sequenceDatabase.getSequences().set(i, newSequence);
                    continue;
                }
                this.sequenceDatabase.getSequences().set(i, null);
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : mapSequenceID.entrySet()) {
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute && !this.isUsingFrequentItems) continue;
            int item = entry.getKey();
            this.savePattern(item, support, entry.getValue());
            if (this.maximumPatternLength <= 1 || support < this.minsuppAbsolute) continue;
            this.patternBuffer[0] = item;
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseSingleItems(item, entry.getValue());
            this.recursionSingleItems(projectedDatabase, 2, 0);
        }
    }

    private void prefixspanWithMultipleItems(Map<Integer, List<Integer>> mapSequenceID) throws IOException {
        for (int i = 0; i < this.sequenceDatabase.size(); ++i) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int currentPosition = 0;
            int currentItemsetItemCount = 0;
            for (int j = 0; j < sequence.length; ++j) {
                int token = sequence[j];
                if (token > 0) {
                    boolean isFrequent = mapSequenceID.containsKey(token);
                    if (!isFrequent) continue;
                    sequence[currentPosition] = token;
                    ++currentPosition;
                    ++currentItemsetItemCount;
                    continue;
                }
                if (token == -1) {
                    if (currentItemsetItemCount <= 0) continue;
                    sequence[currentPosition] = -1;
                    ++currentPosition;
                    currentItemsetItemCount = 0;
                    continue;
                }
                if (token != -2) continue;
                if (currentPosition > 0) {
                    sequence[currentPosition] = -2;
                    int[] newSequence = new int[currentPosition + 1];
                    System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                    this.sequenceDatabase.getSequences().set(i, newSequence);
                    continue;
                }
                this.sequenceDatabase.getSequences().set(i, null);
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : mapSequenceID.entrySet()) {
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute && !this.isUsingFrequentItems) continue;
            int item = entry.getKey();
            this.savePattern(item, support, entry.getValue());
            if (this.maximumPatternLength <= 1 || support < this.minsuppAbsolute) continue;
            this.patternBuffer[0] = item;
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseFirstTimeMultipleItems(item, entry.getValue());
            this.recursion(this.patternBuffer, projectedDatabase, 2, 0);
        }
    }

    private void savePattern(int item, int support, List<Integer> sequenceIDs) throws IOException {
        SequentialPattern pattern = new SequentialPattern();
        pattern.addItemset(new Itemset(item));
        pattern.setSequenceIDs(sequenceIDs);
        this.patterns.addSequence(pattern, 1);
        MemoryLogger.getInstance().checkMemory();
    }

    private void savePattern(int lastBufferPosition, List<PseudoSequence> pseudoSequences) throws IOException {
        SequentialPattern pattern = new SequentialPattern();
        int itemsetCount = 0;
        Itemset currentItemset = new Itemset();
        for (int i = 0; i <= lastBufferPosition; ++i) {
            int token = this.patternBuffer[i];
            if (token > 0) {
                currentItemset.addItem(token);
                continue;
            }
            if (token != -1) continue;
            pattern.addItemset(currentItemset);
            currentItemset = new Itemset();
            ++itemsetCount;
        }
        pattern.addItemset(currentItemset);
        ++itemsetCount;
        ArrayList<Integer> sequencesIDs = new ArrayList<Integer>(pseudoSequences.size());
        for (int i = 0; i < pseudoSequences.size(); ++i) {
            sequencesIDs.add(pseudoSequences.get(i).getOriginalSequenceID());
        }
        pattern.setSequenceIDs(sequencesIDs);
        this.patterns.addSequence(pattern, itemsetCount);
        MemoryLogger.getInstance().checkMemory();
    }

    private Map<Integer, List<Integer>> findSequencesContainingItems() {
        if (this.isUsingFrequentItems) {
            for (List<Integer> sequenceIDs : this.mapSequenceID.values()) {
                sequenceIDs.clear();
            }
        } else {
            HashMap<Integer, List<Integer>> mapSequenceID = new HashMap<Integer, List<Integer>>();
            this.mapSequenceID = mapSequenceID;
        }
        for (int i = 0; i < this.sequenceDatabase.size(); ++i) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int itemCountInCurrentItemset = 0;
            for (int token : sequence) {
                if (token > 0) {
                    List<Integer> sequenceIDs = this.mapSequenceID.get(token);
                    if (sequenceIDs == null && !this.isUsingFrequentItems) {
                        sequenceIDs = new ArrayList<Integer>();
                        this.mapSequenceID.put(token, sequenceIDs);
                    } else if (sequenceIDs == null) continue;
                    if (sequenceIDs.size() == 0 || sequenceIDs.get(sequenceIDs.size() - 1) != i) {
                        sequenceIDs.add(i);
                    }
                    if (++itemCountInCurrentItemset <= 1) continue;
                    this.containsItemsetsWithMultipleItems = true;
                    continue;
                }
                if (token != -1) continue;
                itemCountInCurrentItemset = 0;
            }
        }
        return this.mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseSingleItems(int item, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token == item) {
                    if (sequence[j + 1] == -2) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
        }
        return projectedDatabase;
    }

    private List<PseudoSequence> buildProjectedDatabaseFirstTimeMultipleItems(int item, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            if (sequence == null) continue;
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token == item) {
                    boolean isEndOfSequence = sequence[j + 1] == -1 && sequence[j + 2] == -2;
                    if (isEndOfSequence) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
        }
        return projectedDatabase;
    }

    private void recursionSingleItems(List<PseudoSequence> database, int k, int lastBufferPosition) throws IOException {
        Map<Integer, List<PseudoSequence>> itemsPseudoSequences = this.findAllFrequentPairsSingleItems(database, lastBufferPosition);
        database = null;
        for (Map.Entry<Integer, List<PseudoSequence>> entry : itemsPseudoSequences.entrySet()) {
            if (entry.getValue().size() < this.minsuppAbsolute) continue;
            this.patternBuffer[lastBufferPosition + 1] = -1;
            this.patternBuffer[lastBufferPosition + 2] = entry.getKey();
            this.savePattern(lastBufferPosition + 2, entry.getValue());
            if (k >= this.maximumPatternLength) continue;
            this.recursionSingleItems(entry.getValue(), k + 1, lastBufferPosition + 2);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void recursion(int[] patternBuffer, List<PseudoSequence> database, int k, int lastBufferPosition) throws IOException {
        int newBuferPosition;
        Pair pair;
        MapFrequentPairs mapsPairs = this.findAllFrequentPairs(database, lastBufferPosition);
        database = null;
        for (Map.Entry<Pair, Pair> entry : mapsPairs.mapPairsInPostfix.entrySet()) {
            pair = entry.getKey();
            if (pair.getCount() < this.minsuppAbsolute) continue;
            newBuferPosition = lastBufferPosition;
            patternBuffer[++newBuferPosition] = pair.getItem();
            this.savePattern(newBuferPosition, pair.getPseudoSequences());
            if (k >= this.maximumPatternLength) continue;
            this.recursion(patternBuffer, pair.getPseudoSequences(), k + 1, newBuferPosition);
        }
        for (Map.Entry<Pair, Pair> entry : mapsPairs.mapPairs.entrySet()) {
            pair = entry.getKey();
            if (pair.getCount() < this.minsuppAbsolute) continue;
            newBuferPosition = lastBufferPosition;
            patternBuffer[++newBuferPosition] = -1;
            patternBuffer[++newBuferPosition] = pair.getItem();
            this.savePattern(newBuferPosition, pair.getPseudoSequences());
            if (k >= this.maximumPatternLength) continue;
            this.recursion(patternBuffer, pair.getPseudoSequences(), k + 1, newBuferPosition);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    protected Map<Integer, List<PseudoSequence>> findAllFrequentPairsSingleItems(List<PseudoSequence> sequences, int lastBufferPosition) {
        HashMap<Integer, List<PseudoSequence>> mapItemsPseudoSequences = new HashMap<Integer, List<PseudoSequence>>();
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int i = pseudoSequence.getIndexFirstItem();
            while (sequence[i] != -2) {
                int token = sequence[i];
                if (token > 0) {
                    ArrayList<PseudoSequence> listSequences = (ArrayList<PseudoSequence>)mapItemsPseudoSequences.get(token);
                    if (listSequences == null) {
                        listSequences = new ArrayList<PseudoSequence>();
                        mapItemsPseudoSequences.put(token, listSequences);
                    }
                    boolean ok = true;
                    if (listSequences.size() > 0) {
                        boolean bl = ok = ((PseudoSequence)listSequences.get(listSequences.size() - 1)).getSequenceID() != sequenceID;
                    }
                    if (ok) {
                        listSequences.add(new PseudoSequence(sequenceID, i + 1));
                    }
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapItemsPseudoSequences;
    }

    protected MapFrequentPairs findAllFrequentPairs(List<PseudoSequence> sequences, int lastBufferPosition) {
        MapFrequentPairs mapsPairs = new MapFrequentPairs();
        int firstPositionOfLastItemsetInBuffer = lastBufferPosition;
        while (lastBufferPosition > 0) {
            if (--firstPositionOfLastItemsetInBuffer >= 0 && this.patternBuffer[firstPositionOfLastItemsetInBuffer] != -1) continue;
            ++firstPositionOfLastItemsetInBuffer;
            break;
        }
        int positionToBeMatched = firstPositionOfLastItemsetInBuffer;
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int previousItem = sequence[pseudoSequence.getIndexFirstItem() - 1];
            boolean currentItemsetIsPostfix = previousItem != -1;
            boolean isFirstItemset = true;
            int i = pseudoSequence.getIndexFirstItem();
            while (sequence[i] != -2) {
                int token = sequence[i];
                if (token > 0) {
                    Pair pair = new Pair(token);
                    Pair oldPair = currentItemsetIsPostfix ? mapsPairs.mapPairsInPostfix.get(pair) : mapsPairs.mapPairs.get(pair);
                    if (oldPair == null) {
                        if (currentItemsetIsPostfix) {
                            mapsPairs.mapPairsInPostfix.put(pair, pair);
                        } else {
                            mapsPairs.mapPairs.put(pair, pair);
                        }
                    } else {
                        pair = oldPair;
                    }
                    boolean ok = true;
                    if (pair.getPseudoSequences().size() > 0) {
                        boolean bl = ok = pair.getPseudoSequences().get(pair.getPseudoSequences().size() - 1).getSequenceID() != sequenceID;
                    }
                    if (ok) {
                        pair.getPseudoSequences().add(new PseudoSequence(sequenceID, i + 1));
                    }
                    if (currentItemsetIsPostfix && !isFirstItemset) {
                        pair = new Pair(token);
                        oldPair = mapsPairs.mapPairs.get(pair);
                        if (oldPair == null) {
                            mapsPairs.mapPairs.put(pair, pair);
                        } else {
                            pair = oldPair;
                        }
                        ok = true;
                        if (pair.getPseudoSequences().size() > 0) {
                            boolean bl = ok = pair.getPseudoSequences().get(pair.getPseudoSequences().size() - 1).getSequenceID() != sequenceID;
                        }
                        if (ok) {
                            pair.getPseudoSequences().add(new PseudoSequence(sequenceID, i + 1));
                        }
                    }
                    if (!currentItemsetIsPostfix && this.patternBuffer[positionToBeMatched] == token && ++positionToBeMatched > lastBufferPosition) {
                        currentItemsetIsPostfix = true;
                    }
                } else if (token == -1) {
                    isFirstItemset = false;
                    currentItemsetIsPostfix = false;
                    positionToBeMatched = firstPositionOfLastItemsetInBuffer;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapsPairs;
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setShowSequenceIdentifiers(boolean showSequenceIdentifiers) {
        this.showSequenceIdentifiers = showSequenceIdentifiers;
    }

    public boolean isContainsItemsetsWithMultipleItems() {
        return this.containsItemsetsWithMultipleItems;
    }

    public void setMapSequenceID(Map<Integer, List<Integer>> mapSequenceID) {
        this.mapSequenceID = mapSequenceID;
    }

    public Map<Integer, List<Integer>> getMapSequenceID() {
        return this.mapSequenceID;
    }

    public class MapFrequentPairs {
        public final Map<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        public final Map<Pair, Pair> mapPairsInPostfix = new HashMap<Pair, Pair>();
    }
}

