/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prosecco;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPatterns;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.AlgoGetFS;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.ProgressiveSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.ProgressiveSequenceDatabaseCallbacks;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.ProseccoCallbacks;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.Utils;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoProsecco
implements ProgressiveSequenceDatabaseCallbacks {
    protected long startTime;
    protected long noCountTime;
    protected long endTime;
    long prevRuntime;
    long noCountTimeBlock;
    protected int minsuppAbsolute;
    protected SequentialPatterns patterns = null;
    protected Map<Integer, List<Integer>> mapSequenceID;
    protected String outputFilepath;
    private AlgoGetFS alg = new AlgoGetFS();
    protected int sequenceCount = 0;
    boolean containsItemsetsWithMultipleItems = false;
    ProgressiveSequenceDatabase sequenceDatabase;
    ProseccoCallbacks callback;
    double minsupRelative;
    protected int progressivePatternCount;
    protected SequentialPatterns progressivePatterns = null;

    public AlgoProsecco(ProseccoCallbacks callback) {
        this.callback = callback;
    }

    public AlgoProsecco() throws IOException {
    }

    public SequentialPatterns runAlgorithm(String inputFilePath, String outputFilePath, int blockSize, int dbSize, double errorTolerance, double minsupRelative) throws IOException {
        this.startTime = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.prevRuntime = this.startTime;
        this.outputFilepath = outputFilePath;
        this.minsupRelative = minsupRelative;
        this.sequenceDatabase = new ProgressiveSequenceDatabase();
        this.sequenceDatabase.loadFile(inputFilePath, outputFilePath, blockSize, dbSize, errorTolerance, minsupRelative / 2.0, this);
        return null;
    }

    @Override
    public void nextSequenceBlock(List<int[]> block, String outputFilePath, boolean isLast) {
        try {
            double epsilon = this.sequenceDatabase.getError();
            this.sequenceCount = this.sequenceDatabase.size();
            this.minsuppAbsolute = (int)Math.ceil((this.minsupRelative - epsilon / 2.0) * (double)this.sequenceCount);
            if (this.minsuppAbsolute <= 0) {
                this.minsuppAbsolute = 1;
            }
            this.alg.reset();
            if (this.progressivePatterns != null) {
                this.alg.setMapSequenceID(this.mapSequenceID);
            }
            this.patterns = this.alg.getFS(this.sequenceDatabase, this.minsuppAbsolute);
            this.minsuppAbsolute = (int)Math.ceil((this.minsupRelative - epsilon) * (double)this.sequenceDatabase.numSequencesProcessed());
            if (this.minsuppAbsolute <= 0) {
                this.minsuppAbsolute = 1;
            }
            if (this.progressivePatterns == null) {
                this.mapSequenceID = new HashMap<Integer, List<Integer>>(this.alg.getMapSequenceID());
                this.progressivePatterns = this.patterns.copy();
                this.progressivePatternCount = this.patterns.getSequenceCount();
                this.containsItemsetsWithMultipleItems = this.alg.isContainsItemsetsWithMultipleItems();
                MemoryLogger.getInstance().checkMemory();
            } else {
                this.merge();
                this.countInfrequent();
                MemoryLogger.getInstance().checkMemory();
                this.prune();
            }
            if (this.callback != null) {
                long startTime = System.currentTimeMillis();
                this.callback.blockUpdate(this.progressivePatterns, this.sequenceDatabase.numSequencesProcessed(), this.getCurrentBatchRuntime(), this.getCurrentError());
                long endTime = System.currentTimeMillis();
                this.noCountTime += endTime - startTime;
                this.noCountTimeBlock += endTime - startTime;
            } else if (this.outputFilepath != null) {
                long startTime = System.currentTimeMillis();
                this.savePatternsToFile(this.progressivePatterns);
                long endTime = System.currentTimeMillis();
                this.noCountTime += endTime - startTime;
                this.noCountTimeBlock += endTime - startTime;
            }
            if (isLast) {
                this.endTime = System.currentTimeMillis();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void merge() {
        int k = 0;
        for (List<SequentialPattern> level : this.progressivePatterns.getLevels()) {
            block1: for (SequentialPattern pattern : level) {
                pattern.setIsFound(false);
                if (k >= this.patterns.getLevelCount()) continue;
                for (SequentialPattern newPattern : this.patterns.getLevel(k)) {
                    if (!newPattern.equals(pattern)) continue;
                    pattern.setIsFound(true);
                    pattern.addAdditionalSupport(newPattern.getAbsoluteSupport());
                    continue block1;
                }
            }
            ++k;
        }
    }

    private void countInfrequent() {
        for (List<SequentialPattern> level : this.progressivePatterns.getLevels()) {
            for (SequentialPattern pattern : level) {
                if (pattern.isFound()) continue;
                for (int[] sequence : this.sequenceDatabase.getSequences()) {
                    if (sequence == null || !Utils.isSubsequenceOf(pattern, sequence, this.containsItemsetsWithMultipleItems)) continue;
                    pattern.addAdditionalSupport(1);
                }
            }
        }
    }

    private void prune() {
        for (List<SequentialPattern> level : this.progressivePatterns.getLevels()) {
            for (int i = level.size() - 1; i >= 0; --i) {
                SequentialPattern pattern = level.get(i);
                if (pattern.getAbsoluteSupport() >= this.minsuppAbsolute) continue;
                if (pattern.size() == 1) {
                    this.mapSequenceID.remove(pattern.get(0).get(0));
                }
                level.remove(i);
                --this.progressivePatternCount;
            }
        }
    }

    public long getCurrentBatchRuntime() {
        long batchRuntime = System.currentTimeMillis() - this.noCountTimeBlock - this.prevRuntime;
        this.prevRuntime = System.currentTimeMillis();
        this.noCountTimeBlock = 0L;
        return batchRuntime;
    }

    public long getTotalRuntime() {
        return this.endTime - this.startTime - this.noCountTime;
    }

    public double getCurrentError() {
        return this.sequenceDatabase.getError();
    }

    private void savePatternsToFile(SequentialPatterns patterns) throws IOException {
        File file = new File(this.outputFilepath);
        file.delete();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFilepath));
        StringBuilder r = new StringBuilder();
        for (List<SequentialPattern> patternsAtLevel : patterns.getLevels()) {
            for (SequentialPattern pattern : patternsAtLevel) {
                for (Itemset it : pattern.getItemsets()) {
                    for (Integer item : it.getItems()) {
                        r.append(item);
                        r.append(" ");
                    }
                    r.append("-1");
                }
                r.append(" ");
                r.append("#SUP: ");
                r.append(pattern.getAbsoluteSupport());
                r.append("\n");
            }
        }
        writer.write(r.toString());
        writer.newLine();
        writer.close();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  PROSECCO - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime - this.noCountTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.progressivePatternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append(" minsup = " + this.minsuppAbsolute + " sequences.");
        r.append('\n');
        r.append(" Pattern count : ");
        r.append(this.progressivePatternCount);
        r.append('\n');
        r.append("===================================================\n");
        if (this.progressivePatterns != null) {
            this.progressivePatterns.printFrequentPatterns(this.sequenceDatabase.numSequencesProcessed(), false);
        }
        System.out.println(r.toString());
    }
}

