/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prosecco;

import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.Transaction;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Metadata {
    private double errorTolerance;
    private int dbSize;
    private int numBlocks;
    private int numSequencesProcessed = 0;
    private int iteration = 1;
    private List<Transaction> capSequences;
    private long sIndex;

    public Metadata(double errorTolerance, int blockSize, int dbSize) {
        this.errorTolerance = errorTolerance;
        this.dbSize = dbSize;
        this.numBlocks = (int)Math.ceil((float)dbSize / (float)blockSize);
        this.capSequences = new ArrayList<Transaction>();
    }

    public void UpdateWithSequence(int[] seq, int numItems) {
        ++this.numSequencesProcessed;
        if ((long)Math.pow(2.0, numItems) > (long)Math.pow(2.0, this.sIndex)) {
            long c = this.getCapBound(seq);
            this.capSequences.add(new Transaction(seq, numItems, c));
            Collections.sort(this.capSequences);
            if ((double)this.capSequences.get((int)0).priority < Math.pow(2.0, this.capSequences.size()) - 1.0) {
                this.capSequences.remove(0);
            }
            this.sIndex = this.capSequences.size();
        }
    }

    public void UpdateWithSequenceDIndex(int[] seq, int numItems) {
        Transaction trans;
        ++this.numSequencesProcessed;
        if ((long)numItems > this.sIndex && !this.capSequences.contains(trans = new Transaction(seq, numItems, numItems))) {
            int i;
            this.capSequences.add(new Transaction(seq, numItems, numItems));
            Collections.sort(this.capSequences);
            this.sIndex = 1L;
            for (i = this.capSequences.size() - 1; i >= 0 && this.sIndex <= (long)this.capSequences.get((int)i).numItems; --i) {
                ++this.sIndex;
            }
            --this.sIndex;
            for (i = this.capSequences.size() - 1; i >= 0 && (long)(i + 1) > this.sIndex; --i) {
                this.capSequences.remove(i);
            }
        }
    }

    public double GetError() {
        if (this.numSequencesProcessed >= this.dbSize) {
            return 0.0;
        }
        double epsilon = Math.sqrt(((double)this.sIndex - Math.log(this.errorTolerance) + Math.log(this.numBlocks)) / (double)(2 * this.numSequencesProcessed));
        if (Double.isInfinite(epsilon) || Double.isNaN(epsilon)) {
            return 0.0;
        }
        return epsilon;
    }

    private long getCapBound(int[] sequence) {
        LinkedList<Itemset> list = new LinkedList<Itemset>();
        Itemset it = new Itemset();
        int length = 0;
        for (int el : sequence) {
            if (el >= 0) {
                ++length;
                it.addItem(el);
                continue;
            }
            if (el == -1) {
                list.add(it.cloneItemSet());
                it = new Itemset();
                continue;
            }
            if (el == -2) break;
        }
        long c = (long)Math.pow(2.0, length) - 1L;
        while (list.size() > 1) {
            Itemset itA = (Itemset)list.pop();
            for (int i = 0; i < list.size(); ++i) {
                if (!itA.containsAll((Itemset)list.get(i))) continue;
                c = (int)((double)c - Math.pow(2.0, ((Itemset)list.get(i)).size()) + 1.0);
                list.remove(i);
            }
        }
        return c;
    }

    public int getNumSequencesProcessed() {
        return this.numSequencesProcessed;
    }
}

