/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prosecco;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.Metadata;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.ProgressiveSequenceDatabaseCallbacks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ProgressiveSequenceDatabase
extends SequenceDatabase {
    private Metadata metadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String inputPath, String outputPath, int blockSize, int dbSize, double errorTolerance, double startErrorThreshold, ProgressiveSequenceDatabaseCallbacks callback) throws IOException {
        this.metadata = new Metadata(errorTolerance, blockSize, dbSize);
        this.itemOccurrenceCount = 0L;
        this.sequences = new ArrayList();
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(inputPath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] tokens = thisLine.split(" ");
                int numItems = 0;
                int[] sequence = new int[tokens.length];
                for (int j = 0; j < tokens.length; ++j) {
                    sequence[j] = Integer.parseInt(tokens[j]);
                    if (sequence[j] < 0) continue;
                    ++numItems;
                }
                this.metadata.UpdateWithSequence(sequence, numItems);
                this.sequences.add(sequence);
                if (this.sequences.size() % blockSize != 0 || !(this.metadata.GetError() < startErrorThreshold)) continue;
                ArrayList<int[]> block = new ArrayList<int[]>(this.sequences);
                callback.nextSequenceBlock(block, outputPath, false);
                this.sequences.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                callback.nextSequenceBlock(this.sequences, outputPath, true);
                myInput.close();
            }
        }
    }

    public double getError() {
        return this.metadata.GetError();
    }

    public int numSequencesProcessed() {
        return this.metadata.getNumSequencesProcessed();
    }
}

