/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.FileLoader;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalData;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemsetFinder;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.File;

public class AlgoSkopus {
    private double executionTime = 0.0;
    int patternCount = 0;

    public void runAlgorithm(String strMInputFileName, String strMOutputPathName, boolean useLeverageMeasureInsteadOfSupport, boolean showDebugInformation, boolean useSmoothedValues, double smoothingCoefficient, int maximumSequentialPatternLength, int k) throws Exception {
        double startTime = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        GlobalData.nInterestingnessMeasure = useLeverageMeasureInsteadOfSupport ? 2 : 1;
        if (showDebugInformation) {
            GlobalData.bDebugInformation = true;
        }
        if (maximumSequentialPatternLength < 0) {
            maximumSequentialPatternLength = 0;
        }
        GlobalData.nMaxResultPatternLength = maximumSequentialPatternLength;
        GlobalData.dSmoothCoefficient = useSmoothedValues ? smoothingCoefficient : 0.5;
        if (k < 0) {
            k = 0;
        }
        GlobalData.nK = k;
        GlobalData.Init();
        FileLoader fl = new FileLoader();
        fl.loadData(strMInputFileName);
        ItemsetFinder isF = new ItemsetFinder();
        isF.strDebugFile = strMOutputPathName + "-debug.txt";
        File fileFileName = new File(isF.strDebugFile);
        if (fileFileName.exists()) {
            fileFileName.delete();
        }
        isF.generateResultItemsets();
        this.patternCount = isF.pqMItemsetTopk.size();
        isF.outputResult(strMOutputPathName);
        double endTime = System.currentTimeMillis();
        this.executionTime = endTime - startTime;
    }

    public void printStats() {
        System.out.println("=============  Skopus algorithm v2.34 - STATS =======");
        System.out.println(" Pattern count: " + this.patternCount);
        System.out.println(" Total time ~ " + this.executionTime + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Input file information");
        System.out.println("  number of symbols: " + GlobalData.nNumOfItems);
        System.out.println("  number of sequences: " + GlobalData.nNumOfSequence);
        System.out.println("  average sequence length: " + GlobalData.dSampleAverageLength);
        System.out.println("  maximum sequence length: " + GlobalData.nSampleMaxLength);
        System.out.println("===========================================================");
    }
}

