/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.Combination;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalOper;
import java.util.ArrayList;

public class BinPartitionTemplate
extends ArrayList<Byte[]> {
    private int nMLength = 0;

    public BinPartitionTemplate(int nLength) {
        if (nLength < 2) {
            this.clear();
            return;
        }
        this.nMLength = nLength;
        int nTotalSize = 0;
        for (int i = 1; i <= this.nMLength / 2; ++i) {
            nTotalSize += (int)Math.ceil(Math.exp(GlobalOper.log_combin(this.nMLength, i)));
        }
        this.ensureCapacity(nTotalSize + 2);
        this.createAllPartition();
    }

    private void createAllPartition() {
        this.clear();
        for (int ix = 1; ix <= this.nMLength / 2; ++ix) {
            Combination c = new Combination(this.nMLength, ix);
            while (c.hasNext()) {
                int i;
                int[] a = c.next();
                Byte[] naTemplate = new Byte[this.nMLength];
                for (i = 0; i < naTemplate.length; ++i) {
                    naTemplate[i] = 1;
                }
                for (i = 0; i < a.length; ++i) {
                    naTemplate[a[i]] = 0;
                }
                this.add(naTemplate);
            }
        }
    }

    public int getLength() {
        return this.nMLength;
    }
}

