/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

public class Combination {
    private int n;
    private int r;
    private int[] index;
    private boolean hasNext = true;

    public Combination(int n, int r) {
        this.n = n;
        this.r = r;
        this.index = new int[r];
        for (int i = 0; i < r; ++i) {
            this.index[i] = i;
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    private void moveIndex() {
        int i = this.rightmostIndexBelowMax();
        if (i >= 0) {
            this.index[i] = this.index[i] + 1;
            for (int j = i + 1; j < this.r; ++j) {
                this.index[j] = this.index[j - 1] + 1;
            }
        } else {
            this.hasNext = false;
        }
    }

    public int[] next() {
        if (!this.hasNext) {
            return null;
        }
        int[] result = new int[this.r];
        for (int i = 0; i < this.r; ++i) {
            result[i] = this.index[i];
        }
        this.moveIndex();
        return result;
    }

    private int rightmostIndexBelowMax() {
        for (int i = this.r - 1; i >= 0; --i) {
            if (this.index[i] >= this.n - this.r + i) continue;
            return i;
        }
        return -1;
    }
}

