/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalData;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.SidSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class FileLoader {
    public void loadData(String strParaFileName) throws UnsupportedEncodingException {
        HashMap<String, Integer> itemstrs = new HashMap<String, Integer>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(strParaFileName), "UTF-8"));
            try {
                String strTheLine = null;
                while ((strTheLine = br.readLine()) != null) {
                    if (strTheLine.trim().isEmpty() || strTheLine.charAt(0) == '#' || strTheLine.charAt(0) == '%' || strTheLine.charAt(0) == '@') continue;
                    this.parseOneLine(strTheLine.trim(), ++GlobalData.nNumOfSequence, itemstrs);
                }
                GlobalData.dSampleAverageLength /= (double)GlobalData.nNumOfSequence * 1.0;
                assert (GlobalData.nNumOfItems == GlobalData.alItemName.size());
                assert (GlobalData.nNumOfItems == GlobalData.alSids.size());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void parseOneLine(String strParaLine, int nParaNumofTran, Map<String, Integer> itemstrs) {
        int nPosition = 0;
        for (String token : strParaLine.split(" ")) {
            int thisid;
            if (token.equals("-1") || token.equals("-2")) continue;
            if (itemstrs.containsKey(token)) {
                thisid = itemstrs.get(token);
            } else {
                thisid = GlobalData.alItemName.size();
                itemstrs.put(token, thisid);
                GlobalData.alItemName.add(token);
                GlobalData.nNumOfItems = GlobalData.alItemName.size();
            }
            ++nPosition;
            if (thisid >= GlobalData.alSids.size()) {
                SidSet ss = new SidSet();
                ss.addItem(nParaNumofTran, nPosition);
                GlobalData.alSids.add(ss);
            } else {
                GlobalData.alSids.get(thisid).addItem(nParaNumofTran, nPosition);
            }
            assert (GlobalData.alSids.size() == GlobalData.alItemName.size());
        }
        GlobalData.alSequenceLengthList.add(nPosition);
        GlobalData.dSampleAverageLength += (double)nPosition;
        if (nPosition > GlobalData.nSampleMaxLength) {
            GlobalData.nSampleMaxLength = nPosition;
        }
    }
}

