/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.BinPartition;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.BinPartitionSet;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.BinPartitionTemplate;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.CombinSet;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.CombinTemplate;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalData;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalOper;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemQClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemQElem;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemsetAscSortByValue;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemsetDecSortByValue;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemsetRec;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.SetsOper;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.SidSet;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BinaryOperator;

public class ItemsetFinder {
    PriorityQueue<ItemsetRec> pqMItemsetTopk = new PriorityQueue<Object>(GlobalData.nK, new ItemsetAscSortByValue());
    private double dMMinValueGlobal = 0.0;
    private ArrayList<Double> alMOuterBaseSupport = new ArrayList();
    private HashMap<ItemsetRec, Integer> hmMCheckedSequenceCount = new HashMap();
    private BinPartitionTemplate[] aryMBinPartitionTemplate = new BinPartitionTemplate[11];
    private CombinTemplate[][] aryMCombineTemplate = new CombinTemplate[11][6];
    private final int nTemplateLength = 10;
    public String strDebugFile = "";

    public void generateResultItemsets() {
        int i;
        ItemQClass iqAvailSymbols = new ItemQClass();
        for (i = 0; i < GlobalData.nNumOfItems; ++i) {
            iqAvailSymbols.insert(i);
        }
        iqAvailSymbols.sort();
        if (GlobalData.nInterestingnessMeasure != 1) {
            if ((double)(iqAvailSymbols.size() * (iqAvailSymbols.size() - 1)) * 1.0 / ((double)GlobalData.nK * 1.0) > 100.0 || GlobalData.nMaxResultPatternLength < 3) {
                this.bootstrap2Symbols(iqAvailSymbols);
            } else {
                System.out.println("bootstrap 3");
                this.bootstrap3Symbols(iqAvailSymbols);
            }
        }
        for (i = 0; i < iqAvailSymbols.size(); ++i) {
            ItemsetRec r = new ItemsetRec();
            r.add(((ItemQElem)iqAvailSymbols.get((int)i)).item);
            this.skopus(r, iqAvailSymbols);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void skopus(ItemsetRec irCandidateSequence, ItemQClass iqAvailItems) {
        ItemsetRec irNewSequence;
        if (irCandidateSequence.size() < 1 || iqAvailItems.size() < 1) {
            return;
        }
        if (GlobalData.nMaxResultPatternLength > 0 && irCandidateSequence.size() >= GlobalData.nMaxResultPatternLength) {
            return;
        }
        if (GlobalData.bDebugInformation) {
            GlobalOper.appendFileContent(this.strDebugFile, "\npreifx: " + irCandidateSequence.toString() + "\n");
            GlobalOper.appendFileContent(this.strDebugFile, "symbols: " + iqAvailItems.toString() + "\n\n");
        }
        ItemQClass iqNewAvialItems = new ItemQClass();
        for (int ixSymbol = 0; ixSymbol < iqAvailItems.size(); ++ixSymbol) {
            irNewSequence = new ItemsetRec(irCandidateSequence);
            irNewSequence.add(((ItemQElem)iqAvailItems.get((int)ixSymbol)).item);
            this.evaluateSequencePattern(irNewSequence);
            double dUBVal = this.getUpperBound(irNewSequence);
            if (!(dUBVal >= this.dMMinValueGlobal)) continue;
            iqNewAvialItems.insert(((ItemQElem)iqAvailItems.get((int)ixSymbol)).item, dUBVal);
        }
        iqNewAvialItems.sort();
        for (int ix = 0; ix < iqNewAvialItems.size(); ++ix) {
            irNewSequence = new ItemsetRec(irCandidateSequence);
            irNewSequence.add(((ItemQElem)iqNewAvialItems.get((int)ix)).item);
            irNewSequence.value = ((ItemQElem)iqNewAvialItems.get((int)ix)).ubvalue;
            this.skopus(irNewSequence, iqNewAvialItems);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void evaluateSequencePattern(ItemsetRec isCurrentSequence) {
        int nCoverCount = SetsOper.getCoverAndCount(isCurrentSequence, new SidSet());
        switch (GlobalData.nInterestingnessMeasure) {
            case 1: {
                isCurrentSequence.value = this.calcInterestingness(nCoverCount, 0.0);
                if (GlobalData.bDebugInformation) {
                    GlobalOper.appendFileContent(this.strDebugFile, isCurrentSequence.toString() + "\n");
                }
                if (!(isCurrentSequence.value > this.dMMinValueGlobal)) break;
                this.insertOneResultSequence(isCurrentSequence);
                if (!GlobalData.bDebugInformation) break;
                ArrayList<ItemsetRec> alItemsetsResult = new ArrayList<ItemsetRec>();
                Iterator<ItemsetRec> itItemsetsResult = this.pqMItemsetTopk.iterator();
                while (itItemsetsResult.hasNext()) {
                    alItemsetsResult.add(new ItemsetRec(itItemsetsResult.next()));
                }
                Collections.sort(alItemsetsResult, new ItemsetDecSortByValue());
                assert (this.pqMItemsetTopk.size() == alItemsetsResult.size());
                GlobalOper.appendFileContent(this.strDebugFile, "\t\t==topK==\t");
                GlobalOper.appendFileContent(this.strDebugFile, isCurrentSequence.toString() + "\t" + ((ItemsetRec)alItemsetsResult.get((int)(alItemsetsResult.size() - 1))).value + "\t" + this.pqMItemsetTopk.size() + "\t" + this.dMMinValueGlobal + "\n");
                break;
            }
            case 2: {
                this.checkSequenceLeverage(isCurrentSequence);
                break;
            }
        }
    }

    private void checkSequenceLeverage(ItemsetRec isTheOneSequence) {
        assert (isTheOneSequence.size() >= 2);
        this.alMOuterBaseSupport.clear();
        int nCoverCount = isTheOneSequence.count;
        assert (nCoverCount > 0);
        if (nCoverCount <= 1) {
            isTheOneSequence.value = 0.0;
            return;
        }
        this.hmMCheckedSequenceCount.clear();
        this.hmMCheckedSequenceCount.put(isTheOneSequence, nCoverCount);
        BinPartitionTemplate bpt = this.getPartitionTemplate(isTheOneSequence.size());
        BinPartitionSet bpset = new BinPartitionSet(bpt.size());
        bpset.createAllPartition(isTheOneSequence, bpt);
        for (BinPartition bp : bpset) {
            if (bp == null) continue;
            this.checkOnePartition(bp, isTheOneSequence);
        }
        double nBaseCount = ItemsetFinder.getMaxDouble(this.alMOuterBaseSupport);
        isTheOneSequence.value = this.calcInterestingness(nCoverCount, nBaseCount);
        if (GlobalData.bDebugInformation) {
            GlobalOper.appendFileContent(this.strDebugFile, "\n" + isTheOneSequence.toString() + "\n");
        }
        if (isTheOneSequence.value > this.dMMinValueGlobal) {
            this.insertOneResultSequence(isTheOneSequence);
            if (GlobalData.bDebugInformation) {
                ArrayList<ItemsetRec> alItemsetsResult = new ArrayList<ItemsetRec>();
                Iterator<ItemsetRec> itItemsetsResult = this.pqMItemsetTopk.iterator();
                while (itItemsetsResult.hasNext()) {
                    alItemsetsResult.add(new ItemsetRec(itItemsetsResult.next()));
                }
                Collections.sort(alItemsetsResult, new ItemsetDecSortByValue());
                assert (this.pqMItemsetTopk.size() == alItemsetsResult.size());
                GlobalOper.appendFileContent(this.strDebugFile, "\t\t==topK==\t");
                GlobalOper.appendFileContent(this.strDebugFile, isTheOneSequence.toString() + "\t" + ((ItemsetRec)alItemsetsResult.get((int)(alItemsetsResult.size() - 1))).value + "\t" + this.pqMItemsetTopk.size() + "\t" + this.dMMinValueGlobal + "\n");
            }
        }
    }

    private void checkOnePartition(BinPartition bpOnePartition, ItemsetRec irOriginalOne) {
        if (irOriginalOne.size() < 1) {
            return;
        }
        ArrayList<Integer> alMInnerBaseSupport = new ArrayList<Integer>();
        alMInnerBaseSupport.clear();
        ItemsetRec isLeft = bpOnePartition.getLeft();
        ItemsetRec isRight = bpOnePartition.getRight();
        CombinTemplate ct = this.getCombineTemplate(isLeft.size(), isRight.size());
        CombinSet cs = new CombinSet(ct.size());
        cs.createAllCombin(isLeft, isRight, ct);
        for (ItemsetRec isNew : cs) {
            if (isNew.equals(irOriginalOne)) {
                alMInnerBaseSupport.add(irOriginalOne.count);
                continue;
            }
            int nCoverCount = Integer.MAX_VALUE;
            Integer alreadyComputedSupport = this.hmMCheckedSequenceCount.get(isNew);
            if (alreadyComputedSupport == null) {
                nCoverCount = SetsOper.getCoverAndCount(isNew, new SidSet());
                this.hmMCheckedSequenceCount.put(isNew, nCoverCount);
            } else {
                nCoverCount = isNew.count = this.hmMCheckedSequenceCount.get(isNew).intValue();
            }
            alMInnerBaseSupport.add(nCoverCount);
        }
        this.alMOuterBaseSupport.add(ItemsetFinder.getMean(alMInnerBaseSupport));
    }

    public String toString() {
        String strResult = new String();
        ArrayList<ItemsetRec> alItemsetsResult = new ArrayList<ItemsetRec>();
        Iterator<ItemsetRec> itItemsetsResult = this.pqMItemsetTopk.iterator();
        while (itItemsetsResult.hasNext()) {
            alItemsetsResult.add(new ItemsetRec(itItemsetsResult.next()));
        }
        Collections.sort(alItemsetsResult, new ItemsetDecSortByValue());
        for (int i = 0; i < alItemsetsResult.size(); ++i) {
            strResult = strResult + ((ItemsetRec)alItemsetsResult.get(i)).toString() + "\n";
        }
        return strResult;
    }

    public void outputResult(String strFilename) {
        File fileFileName = new File(strFilename);
        if (fileFileName.exists()) {
            fileFileName.delete();
        }
        GlobalOper.appendFileContent(strFilename, this.toString());
    }

    private static final double getMean(ArrayList<Integer> al) {
        Optional<Integer> res = al.stream().reduce(new BinaryOperator<Integer>(){

            @Override
            public Integer apply(Integer t, Integer u) {
                return t + u;
            }
        });
        if (res.isPresent()) {
            return 1.0 * (double)res.get().intValue() / (double)al.size();
        }
        return Double.MAX_VALUE;
    }

    private static final double getMaxDouble(ArrayList<Double> al) {
        Optional<Double> res = al.stream().max(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o1, o2);
            }
        });
        if (res.isPresent()) {
            return res.get();
        }
        return 0.0;
    }

    private double calcInterestingness(int nCoverCount, double nBaseCoverCount) {
        double dResult = 0.0;
        switch (GlobalData.nInterestingnessMeasure) {
            case 1: {
                dResult = nCoverCount;
                break;
            }
            case 2: {
                dResult = (double)nCoverCount - nBaseCoverCount;
                break;
            }
            default: {
                dResult = 0.0;
            }
        }
        return dResult;
    }

    private void insertOneResultSequence(ItemsetRec ir) {
        double newMin;
        if (ir.value <= this.dMMinValueGlobal || ir.size() <= 1) {
            return;
        }
        if (this.pqMItemsetTopk.contains(ir)) {
            return;
        }
        ItemsetRec copy = new ItemsetRec(ir);
        while (this.pqMItemsetTopk.size() >= GlobalData.nK) {
            this.pqMItemsetTopk.poll();
        }
        this.pqMItemsetTopk.add(copy);
        if (this.pqMItemsetTopk.size() == GlobalData.nK && (newMin = this.pqMItemsetTopk.peek().value) > this.dMMinValueGlobal) {
            this.dMMinValueGlobal = newMin;
        }
        if (this.pqMItemsetTopk.peek().value == 0.0) {
            System.err.println("was inserting " + copy + " when went to...");
        }
    }

    private double getUpperBound(ItemsetRec ir) {
        int nCoverCount = ir.count;
        if (nCoverCount <= 1) {
            return -1.0;
        }
        double dResult = -1.0;
        switch (GlobalData.nInterestingnessMeasure) {
            case 1: {
                dResult = GlobalOper.computeCoverCount(nCoverCount);
                break;
            }
            case 2: {
                dResult = GlobalOper.computeCoverCount(nCoverCount);
                break;
            }
            default: {
                dResult = -1.0;
            }
        }
        return dResult;
    }

    private void bootstrap2Symbols(ItemQClass iqAvailSymbols) {
        for (int i = 0; i < iqAvailSymbols.size(); ++i) {
            for (int j = 0; j < iqAvailSymbols.size(); ++j) {
                ItemsetRec irNewSequence = new ItemsetRec();
                irNewSequence.add(((ItemQElem)iqAvailSymbols.get((int)i)).item);
                irNewSequence.add(((ItemQElem)iqAvailSymbols.get((int)j)).item);
                this.evaluateSequencePattern(irNewSequence);
            }
        }
        System.out.println("Finished bootstrap depth 2");
    }

    private void bootstrap3Symbols(ItemQClass iqAvailSymbols) {
        this.bootstrap2Symbols(iqAvailSymbols);
        ItemsetRec pattern = new ItemsetRec();
        for (int i = 0; i < iqAvailSymbols.size(); ++i) {
            pattern.add(((ItemQElem)iqAvailSymbols.get((int)i)).item);
            for (int j = 0; j < iqAvailSymbols.size(); ++j) {
                pattern.add(((ItemQElem)iqAvailSymbols.get((int)j)).item);
                SetsOper.getCoverAndCount(pattern, new SidSet());
                double ub = this.getUpperBound(pattern);
                if (ub >= this.dMMinValueGlobal) {
                    for (int k = 0; k < iqAvailSymbols.size() && k < 100; ++k) {
                        pattern.add(((ItemQElem)iqAvailSymbols.get((int)k)).item);
                        this.evaluateSequencePattern(pattern);
                        pattern.remove(pattern.size() - 1);
                    }
                }
                pattern.remove(pattern.size() - 1);
            }
            pattern.remove(pattern.size() - 1);
        }
        System.out.println("finished bootstrap 3");
    }

    private void bootstrap4SymbolsFromTopK3(ItemQClass iqAvailSymbols) {
        int insertPosition;
        int i;
        Object pattern;
        this.bootstrap2Symbols(iqAvailSymbols);
        Iterator<ItemsetRec> itItemsetsResult = this.pqMItemsetTopk.iterator();
        ArrayList<Object> copyTopK = new ArrayList<Object>();
        while (itItemsetsResult.hasNext()) {
            pattern = new ItemsetRec(itItemsetsResult.next());
            copyTopK.add(pattern);
        }
        for (ItemsetRec itemsetRec2 : copyTopK) {
            for (i = 0; i < iqAvailSymbols.size(); ++i) {
                for (insertPosition = 0; insertPosition <= itemsetRec2.size(); ++insertPosition) {
                    itemsetRec2.add(insertPosition, ((ItemQElem)iqAvailSymbols.get((int)i)).item);
                    this.evaluateSequencePattern(itemsetRec2);
                    itemsetRec2.remove(insertPosition);
                }
            }
        }
        itItemsetsResult = this.pqMItemsetTopk.iterator();
        copyTopK.clear();
        copyTopK = new ArrayList();
        while (itItemsetsResult.hasNext()) {
            pattern = new ItemsetRec(itItemsetsResult.next());
            copyTopK.add(pattern);
        }
        for (ItemsetRec itemsetRec3 : copyTopK) {
            for (i = 0; i < iqAvailSymbols.size(); ++i) {
                for (insertPosition = 0; insertPosition <= itemsetRec3.size(); ++insertPosition) {
                    itemsetRec3.add(insertPosition, ((ItemQElem)iqAvailSymbols.get((int)i)).item);
                    this.evaluateSequencePattern(itemsetRec3);
                    itemsetRec3.remove(insertPosition);
                }
            }
        }
    }

    private CombinTemplate getCombineTemplate(int nLeftLength, int nRightLength) {
        int nRight;
        int nLeft;
        if (nLeftLength < 1 || nRightLength < 1) {
            return null;
        }
        if (nLeftLength <= nRightLength) {
            nLeft = nLeftLength;
            nRight = nRightLength;
        } else {
            nLeft = nRightLength;
            nRight = nLeftLength;
        }
        if (nLeft + nRight <= 10) {
            if (this.aryMCombineTemplate[nLeft + nRight][nLeft] == null) {
                this.aryMCombineTemplate[nLeft + nRight][nLeft] = new CombinTemplate(nLeft, nRight);
            }
            return this.aryMCombineTemplate[nLeft + nRight][nLeft];
        }
        return new CombinTemplate(nLeft, nRight);
    }

    private BinPartitionTemplate getPartitionTemplate(int nLength) {
        if (nLength < 2) {
            return null;
        }
        if (nLength <= 10) {
            if (this.aryMBinPartitionTemplate[nLength] == null) {
                this.aryMBinPartitionTemplate[nLength] = new BinPartitionTemplate(nLength);
            }
            return this.aryMBinPartitionTemplate[nLength];
        }
        return new BinPartitionTemplate(nLength);
    }
}

