/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalData;
import java.util.ArrayList;

public class ItemsetRec
extends ArrayList<Integer> {
    private static final long serialVersionUID = -8974421858134023255L;
    public int count;
    public double value;
    public boolean self_sufficient;

    public ItemsetRec() {
        this.clear();
        this.count = 0;
        this.value = 0.0;
        this.self_sufficient = false;
    }

    public ItemsetRec(int nLength) {
        super(nLength);
        this.clear();
        this.count = 0;
        this.value = 0.0;
        this.self_sufficient = false;
    }

    public ItemsetRec(ItemsetRec ir) {
        super(ir.size());
        this.clear();
        this.addAll(ir);
        this.count = ir.count;
        this.value = ir.value;
        this.self_sufficient = ir.self_sufficient;
    }

    public ItemsetRec(ItemsetRec ir, int nBeginIX, int nEndIX) {
        super(ir.size());
        this.clear();
        if (nBeginIX > nEndIX || nBeginIX < 0 || nEndIX >= ir.size()) {
            return;
        }
        for (int ix = nBeginIX; ix <= nEndIX; ++ix) {
            this.add((Integer)ir.get(ix));
        }
    }

    public boolean isAllSame() {
        if (this.size() <= 1) {
            return true;
        }
        for (int i = 1; i < this.size(); ++i) {
            if (((Integer)this.get(i)).equals(this.get(i - 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ItemsetRec)) {
            return false;
        }
        ItemsetRec list = (ItemsetRec)o;
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Integer)this.get(i)).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        String strResult = new String();
        if (this.size() > 0) {
            for (int i = 0; i < this.size() - 1; ++i) {
                strResult = strResult + GlobalData.alItemName.get((Integer)this.get(i)) + " -1 ";
            }
            strResult = strResult + GlobalData.alItemName.get((Integer)this.get(this.size() - 1)) + " -1 ";
        }
        strResult = strResult + "#SUP: " + this.count;
        if (GlobalData.nInterestingnessMeasure == 2) {
            strResult = strResult + " #LEVERAGE: " + this.value;
        }
        return strResult;
    }
}

