/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalData;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemsetRec;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.Sid;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.SidSet;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.SidSortByNumber;
import java.util.Collections;

public class SetsOper {
    public static int intersection(SidSet result, SidSet s1, SidSet s2) {
        result.clear();
        result.ensureCapacity(s1.size() < s2.size() ? s1.size() : s2.size());
        if (s1.size() == 0 || s2.size() == 0) {
            return 0;
        }
        int it1 = 0;
        int it2 = 0;
        int end1 = s1.size();
        int end2 = s2.size();
        Sid v1 = (Sid)s1.get(0);
        Sid v2 = (Sid)s2.get(0);
        while (true) {
            if (v1.isEqual(v2)) {
                int pos = v1.getNextPosition(v2);
                if (pos >= 0) {
                    Sid v = new Sid(v1.getSidNumber(), pos);
                    result.add(v);
                }
                if (++it1 >= end1) break;
                v1 = (Sid)s1.get(it1);
                if (++it2 >= end2) break;
                v2 = (Sid)s2.get(it2);
                continue;
            }
            if (v1.lessThan(v2)) {
                if (++it1 >= end1) break;
                v1 = (Sid)s1.get(it1);
                continue;
            }
            if (++it2 >= end2) break;
            v2 = (Sid)s2.get(it2);
        }
        return result.size();
    }

    public static int getCoverAndCount(ItemsetRec is, SidSet sResult) {
        int nResult = 0;
        sResult.clear();
        if (is.size() < 1) {
            nResult = 0;
            sResult.clear();
        } else if (is.size() == 1) {
            sResult = GlobalData.alSids.get((Integer)is.get(0));
            nResult = sResult.size();
        } else {
            SidSet r = new SidSet();
            r.copyFrom(GlobalData.alSids.get((Integer)is.get(0)));
            for (int i = 1; i < is.size(); ++i) {
                SidSet temp = new SidSet();
                nResult = SetsOper.intersection(temp, r, GlobalData.alSids.get((Integer)is.get(i)));
                if (nResult < 1) {
                    sResult.clear();
                    break;
                }
                r.copyFrom(temp);
                sResult.copyFrom(temp);
            }
        }
        is.count = nResult;
        return nResult;
    }

    public static void dintersection(SidSet s1, SidSet s2) {
        SidSet result = new SidSet(s1.size() < s2.size() ? s1.size() : s2.size());
        SetsOper.intersection(result, s1, s2);
        s1.copyFrom(result);
    }

    public static SidSet getUnion(SidSet s1, SidSet s2) {
        SidSet s3 = new SidSet(s1.size() + s2.size());
        Collections.sort(s1, new SidSortByNumber());
        Collections.sort(s2, new SidSortByNumber());
        int it1 = 0;
        int it2 = 0;
        int end1 = s1.size();
        int end2 = s2.size();
        while (true) {
            if (it1 >= end1 - 1) {
                while (it2 < end2) {
                    s3.add((Sid)s2.get(it2));
                    ++it2;
                }
                break;
            }
            if (it2 >= end2 - 1) {
                while (it1 <= end1 - 1) {
                    s3.add((Sid)s1.get(it1));
                    ++it1;
                }
                break;
            }
            if (((Sid)s1.get(it1)).isEqual((Sid)s2.get(it2))) {
                s3.add((Sid)s1.get(it1));
                ++it1;
                ++it2;
                continue;
            }
            if (((Sid)s1.get(it1)).lessThan((Sid)s2.get(it2))) {
                s3.add((Sid)s1.get(it1));
                ++it1;
                continue;
            }
            s3.add((Sid)s2.get(it2));
            ++it2;
        }
        return s3;
    }

    public static void dUnion(SidSet s1, SidSet s2) {
        SidSet result = SetsOper.getUnion(s1, s2);
        s1.copyFrom(result);
    }

    public static SidSet getIntersection(SidSet s1, SidSet s2) {
        SidSet s3 = new SidSet(s1.size() < s2.size() ? s1.size() : s2.size());
        int it1 = 0;
        int it2 = 0;
        int end1 = s1.size();
        int end2 = s2.size();
        while (it1 < end1 && it2 < end2) {
            if (((Sid)s1.get(it1)).isEqual((Sid)s2.get(it2))) {
                s3.add((Sid)s1.get(it1));
                ++it1;
                ++it2;
                continue;
            }
            if (((Sid)s1.get(it1)).lessThan((Sid)s2.get(it2))) {
                ++it1;
                continue;
            }
            ++it2;
        }
        return s3;
    }
}

