/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.PatternCreator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Pattern
implements Comparable<Pattern> {
    private List<ItemAbstractionPair> elements;
    private BitSet appearingIn;

    public Pattern() {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.appearingIn = new BitSet();
    }

    public Pattern(List<ItemAbstractionPair> elements) {
        this.elements = elements;
        this.appearingIn = new BitSet();
    }

    public Pattern(ItemAbstractionPair pair) {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.elements.add(pair);
        this.appearingIn = new BitSet();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            result.append(this.elements.get(i).toString());
        }
        result.append("]");
        return result.toString();
    }

    public String toStringToFile(boolean outputSequenceIdentifiers) {
        int i;
        StringBuilder result = new StringBuilder();
        for (i = 0; i < this.elements.size(); ++i) {
            if (i == this.elements.size() - 1) {
                if (i != 0) {
                    result.append(this.elements.get(i).toStringToFile());
                } else {
                    result.append(this.elements.get(i).getItem());
                }
                result.append(" -1");
                continue;
            }
            if (i == 0) {
                result.append(this.elements.get(i).getItem());
                continue;
            }
            result.append(this.elements.get(i).toStringToFile());
        }
        result.append(" #SUP: ");
        result.append(this.appearingIn.cardinality());
        if (outputSequenceIdentifiers) {
            result.append(" #SID: ");
            i = this.appearingIn.nextSetBit(0);
            while (i >= 0) {
                result.append(i - 1);
                result.append(" ");
                i = this.appearingIn.nextSetBit(i + 1);
            }
        }
        return result.toString();
    }

    public Pattern clonePattern() {
        PatternCreator patternCreator = PatternCreator.getInstance();
        ArrayList<ItemAbstractionPair> elementsCopy = new ArrayList<ItemAbstractionPair>(this.elements);
        Pattern clon = patternCreator.createPattern(elementsCopy);
        return clon;
    }

    public List<ItemAbstractionPair> getElements() {
        return this.elements;
    }

    public ItemAbstractionPair getIthElement(int i) {
        return this.elements.get(i);
    }

    public ItemAbstractionPair getLastButOneElement() {
        if (this.size() > 1) {
            return this.getIthElement(this.size() - 2);
        }
        return null;
    }

    public ItemAbstractionPair getLastElement() {
        if (this.size() > 0) {
            return this.getIthElement(this.size() - 1);
        }
        return null;
    }

    public List<ItemAbstractionPair> getNElements(int n) {
        if (n <= this.elements.size()) {
            return this.elements.subList(0, n - 1);
        }
        return null;
    }

    public void setElements(List<ItemAbstractionPair> elements) {
        this.elements = elements;
    }

    public void add(ItemAbstractionPair pair) {
        this.elements.add(pair);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public int compareTo(Pattern arg) {
        return this.getIthElement(this.size() - 1).compareTo(arg.getIthElement(arg.size() - 1));
    }

    public boolean equals(Object arg) {
        if (arg instanceof Pattern) {
            Pattern p = (Pattern)arg;
            return this.compareTo(p) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }

    public boolean isPrefix(Pattern p) {
        boolean output = false;
        ArrayList<ItemAbstractionPair> pElements = new ArrayList<ItemAbstractionPair>(p.getElements());
        pElements.remove(pElements.size() - 1);
        if (((ItemAbstractionPair)pElements.get(pElements.size() - 1)).equals(this.getIthElement(this.size() - 1))) {
            output = true;
        }
        return output;
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet appearingIn) {
        this.appearingIn = appearingIn;
    }

    public void clear() {
        this.elements.clear();
        this.appearingIn.clear();
    }
}

