/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Candidate;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PatternTKS;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Prefix;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class AlgoTKS {
    private long startTime;
    private long startMiningTime;
    private long endTime;
    private int minsup = 0;
    private int minsupAfterPreProcessing = 0;
    private int k = 0;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    PriorityQueue<PatternTKS> kPatterns;
    PriorityQueue<Candidate> candidates;
    int maxCandidateCount = 0;
    int candidateExplored = 0;
    Set<Integer> discardedItems;
    final boolean useDiscardedItemsPruningStrategy = true;
    final boolean usePruneBranchesInsideDFSPruning = true;
    final boolean rebuildCandidateTreeWhenTooLarge = false;
    int addedCandidatesSinceLastRebuilt = 0;
    final int MIN_CANDIDATES_COUNT_BEFORE_REBUILD = 1500;
    final int MIN_ADDED_CANDIDATE_COUNT_SINCE_LAST_REBUILD_BEFORE_REBUILD = 400;
    final boolean useCooccurrenceInformation = true;
    Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    private int minimumPatternLength = 0;
    private int maximumPatternLength = 1000;
    int[] mustAppearItems;
    private int maxGap = Integer.MAX_VALUE;
    private boolean outputSequenceIdentifiers;

    public PriorityQueue<PatternTKS> runAlgorithm(String input, String outputFilePath, int k) throws IOException {
        MemoryLogger.getInstance().reset();
        this.tks(input, k);
        this.endTime = System.currentTimeMillis();
        return this.kPatterns;
    }

    private PriorityQueue<PatternTKS> tks(String input, int k) throws IOException {
        int containsAMustAppearItem;
        Object[] tokens;
        Object thisLine;
        this.k = k;
        this.minsup = 1;
        this.candidateExplored = 0;
        this.kPatterns = new PriorityQueue();
        this.candidates = new PriorityQueue();
        this.discardedItems = new HashSet<Integer>();
        this.verticalDB = new HashMap<Integer, Bitmap>();
        ArrayList<int[]> inMemoryDB = new ArrayList<int[]>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            FileInputStream fin = new FileInputStream(new File(input));
            BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
            int bitIndex = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (((String)thisLine).isEmpty() || ((String)thisLine).startsWith("#") || ((String)thisLine).charAt(0) == '%' || ((String)thisLine).charAt(0) == '@') continue;
                tokens = ((String)thisLine).split(" ");
                int[] transactionArray = new int[tokens.length];
                containsAMustAppearItem = 0;
                this.sequencesSize.add(bitIndex);
                for (int i = 0; i < tokens.length; ++i) {
                    int item;
                    transactionArray[i] = item = Integer.parseInt((String)tokens[i]);
                    if (item == -1) {
                        ++bitIndex;
                    }
                    if (!this.itemMustAppearInPatterns(item)) continue;
                    containsAMustAppearItem = 1;
                }
                if (containsAMustAppearItem == 0) continue;
                inMemoryDB.add(transactionArray);
            }
            this.lastBitIndex = bitIndex - 1;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startTime = System.currentTimeMillis();
        int sid = 0;
        int tid = 0;
        thisLine = inMemoryDB.iterator();
        while (thisLine.hasNext()) {
            int[] transaction;
            tokens = transaction = (int[])thisLine.next();
            int transactionArray = tokens.length;
            for (containsAMustAppearItem = 0; containsAMustAppearItem < transactionArray; ++containsAMustAppearItem) {
                Integer item = tokens[containsAMustAppearItem];
                if (item == -1) {
                    ++tid;
                    continue;
                }
                if (item == -2) {
                    ++sid;
                    tid = 0;
                    continue;
                }
                Bitmap bitmapItem = this.verticalDB.get(item);
                if (bitmapItem == null) {
                    bitmapItem = new Bitmap(this.lastBitIndex);
                    this.verticalDB.put(item, bitmapItem);
                }
                bitmapItem.registerBit(sid, tid, this.sequencesSize);
            }
        }
        LinkedList frequentItems = new LinkedList();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            Integer item = entry.getKey();
            Integer support = entry.getValue().getSupport();
            if (support < this.minsup) {
                iter.remove();
                continue;
            }
            Prefix prefix = new Prefix();
            prefix.addItemset(new Itemset(item));
            PatternTKS pattern = new PatternTKS(prefix, support);
            if (this.outputSequenceIdentifiers) {
                pattern.bitmap = (Bitmap)entry.getValue();
            }
            if (1 < this.minimumPatternLength || 1 > this.maximumPatternLength) continue;
            this.save(pattern);
        }
        if (this.maximumPatternLength > 1) {
            this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
            this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
            for (int[] transaction : inMemoryDB) {
                HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
                HashMap equalProcessed = new HashMap();
                block8: for (int i = 0; i < transaction.length; ++i) {
                    Bitmap bitmapOfItem;
                    Integer itemI = transaction[i];
                    HashSet<Integer> equalSet = (HashSet<Integer>)equalProcessed.get(itemI);
                    if (equalSet == null) {
                        equalSet = new HashSet<Integer>();
                        equalProcessed.put(itemI, equalSet);
                    }
                    if (itemI < 0 || (bitmapOfItem = this.verticalDB.get(itemI)) == null || bitmapOfItem.getSupport() < this.minsup) continue;
                    HashSet<Integer> alreadyProcessedB = new HashSet<Integer>();
                    boolean sameItemset = true;
                    for (int j = i + 1; j < transaction.length; ++j) {
                        Integer support;
                        Integer itemJ = transaction[j];
                        if (itemJ < 0) {
                            sameItemset = false;
                            continue;
                        }
                        Bitmap bitmapOfitemJ = this.verticalDB.get(itemJ);
                        if (bitmapOfitemJ == null || bitmapOfitemJ.getSupport() < this.minsup) continue;
                        Map<Integer, Integer> map = null;
                        if (sameItemset) {
                            if (equalSet.contains(itemJ)) continue;
                            map = this.coocMapEquals.get(itemI);
                            if (map == null) {
                                map = new HashMap<Integer, Integer>();
                                this.coocMapEquals.put(itemI, map);
                            }
                            if ((support = map.get(itemJ)) == null) {
                                map.put(itemJ, 1);
                            } else {
                                support = support + 1;
                                map.put(itemJ, support);
                            }
                            equalSet.add(itemJ);
                            continue;
                        }
                        if (alreadyProcessedB.contains(itemJ)) continue;
                        if (alreadyProcessed.contains(itemI)) continue block8;
                        map = this.coocMapAfter.get(itemI);
                        if (map == null) {
                            map = new HashMap<Integer, Integer>();
                            this.coocMapAfter.put(itemI, map);
                        }
                        if ((support = map.get(itemJ)) == null) {
                            map.put(itemJ, 1);
                        } else {
                            support = support + 1;
                            map.put(itemJ, support);
                        }
                        alreadyProcessedB.add(itemJ);
                    }
                    alreadyProcessed.add(itemI);
                }
            }
            for (Map.Entry<Integer, Bitmap> entry : this.verticalDB.entrySet()) {
                Bitmap bitmap = entry.getValue();
                if (bitmap.getSupport() < this.minsup) continue;
                ++this.candidateExplored;
                Integer item = entry.getKey();
                Prefix prefix = new Prefix();
                prefix.addItemset(new Itemset(item));
                if (this.coocMapAfter.get(item) == null) continue;
                Set<Integer> afterItems = this.coocMapAfter.get(item).keySet();
                this.registerAsCandidate(new Candidate(prefix, bitmap, afterItems, afterItems, item, 1));
            }
            this.minsupAfterPreProcessing = this.minsup;
            this.startMiningTime = System.currentTimeMillis();
            while (!this.candidates.isEmpty()) {
                Candidate cand = this.candidates.poll();
                if (cand.bitmap.getSupport() < this.minsup) break;
                ++this.candidateExplored;
                this.dfsPruning(cand.prefix, cand.bitmap, cand.sn, cand.in, cand.hasToBeGreaterThanForIStep, cand.candidateLength);
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return this.kPatterns;
    }

    private void save(PatternTKS pattern) {
        if (this.mustAppearItems != null) {
            HashSet<Integer> itemsFound = new HashSet<Integer>();
            block0: for (Itemset itemset2 : pattern.prefix.getItemsets()) {
                for (Integer item : itemset2.getItems()) {
                    if (!this.itemMustAppearInPatterns(item)) continue;
                    itemsFound.add(item);
                    if (itemsFound.size() != this.mustAppearItems.length) continue;
                    break block0;
                }
            }
            if (itemsFound.size() != this.mustAppearItems.length) {
                return;
            }
        }
        this.kPatterns.add(pattern);
        if (this.kPatterns.size() > this.k) {
            if (pattern.support > this.minsup) {
                do {
                    PatternTKS pat = this.kPatterns.poll();
                    if (pat.prefix.size() != 1 || pat.prefix.get(0).size() != 1) continue;
                    this.discardedItems.add(pat.prefix.get(0).get(0));
                } while (this.kPatterns.size() > this.k);
            }
            this.minsup = this.kPatterns.peek().support;
        }
    }

    private void registerAsCandidate(Candidate candidate) {
        this.candidates.add(candidate);
        ++this.addedCandidatesSinceLastRebuilt;
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
    }

    private void dfsPruning(Prefix prefix, Bitmap prefixBitmap, Collection<Integer> sn, Collection<Integer> in, int hasToBeGreaterThanForIStep, int prefixLength) throws IOException {
        int newCandidatesLength = prefixLength + 1;
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        block0: for (Integer i : sn) {
            if (this.discardedItems.contains(i)) continue;
            for (Itemset itemset2 : prefix.getItemsets()) {
                for (Integer itemX : itemset2.getItems()) {
                    Integer support;
                    Map<Integer, Integer> mapSupportItemsAfter = this.coocMapAfter.get(itemX);
                    if (mapSupportItemsAfter != null && (support = mapSupportItemsAfter.get(i)) != null && support >= this.minsup) continue;
                    continue block0;
                }
            }
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex, this.maxGap);
            if (newBitmap.getSupportWithoutGapTotal() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < sTemp.size(); ++k) {
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            if (newBitmap.getSupport() < this.minsup) continue;
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            if (newBitmap.getSupport() < this.minsup) continue;
            if (newCandidatesLength >= this.minimumPatternLength && newCandidatesLength <= this.maximumPatternLength) {
                PatternTKS pattern = new PatternTKS(prefixSStep, newBitmap.getSupport());
                if (this.outputSequenceIdentifiers) {
                    pattern.bitmap = newBitmap;
                }
                this.save(pattern);
            }
            if (newCandidatesLength + 1 > this.maximumPatternLength) continue;
            this.registerAsCandidate(new Candidate(prefixSStep, newBitmap, sTemp, sTemp, item, newCandidatesLength));
        }
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        block4: for (Integer i : in) {
            if (i <= hasToBeGreaterThanForIStep || this.discardedItems.contains(i)) continue;
            for (Itemset itemset3 : prefix.getItemsets()) {
                for (Integer itemX : itemset3.getItems()) {
                    Integer support;
                    Map<Integer, Integer> mapSupportItemsAfter = this.coocMapEquals.get(itemX);
                    if (mapSupportItemsAfter != null && (support = mapSupportItemsAfter.get(i)) != null && support >= this.minsup) continue;
                    continue block4;
                }
            }
            Bitmap newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < iTemp.size(); ++k) {
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k);
            if (newBitmap.getSupport() < this.minsup) continue;
            int item = (Integer)iTemp.get(k);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.getItemsets().get(prefixIStep.size() - 1).addItem(item);
            if (newCandidatesLength >= this.minimumPatternLength && newCandidatesLength <= this.maximumPatternLength) {
                this.save(new PatternTKS(prefixIStep, newBitmap.getSupport()));
            }
            if (newCandidatesLength + 1 > this.maximumPatternLength) continue;
            this.registerAsCandidate(new Candidate(prefixIStep, newBitmap, sTemp, iTemp, item, newCandidatesLength));
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Algorithm TKS v0.97 - STATISTICS =============\n");
        r.append("Minsup after preprocessing : " + this.minsupAfterPreProcessing + "\n");
        r.append("Max candidates: " + this.maxCandidateCount);
        r.append(" Candidates explored  : " + this.candidateExplored + "\n");
        r.append("Pattern found count : " + this.kPatterns.size());
        r.append('\n');
        r.append("Time preprocessing: " + (this.startMiningTime - this.startTime) + " ms \n");
        r.append("Total time: " + (this.endTime - this.startTime) + " ms \n");
        r.append("Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("Final minsup value: " + this.minsup);
        r.append('\n');
        r.append("Intersection count " + Bitmap.INTERSECTION_COUNT + " \n");
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (PatternTKS pattern : this.kPatterns) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(pattern.prefix.toString());
            buffer.append("#SUP: ");
            buffer.append(pattern.support);
            if (this.outputSequenceIdentifiers) {
                buffer.append(" #SID: ");
                buffer.append(pattern.bitmap.getSIDs(this.sequencesSize));
            }
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setMinimumPatternLength(int minimumPatternLength) {
        this.minimumPatternLength = minimumPatternLength;
    }

    public void setMustAppearItems(int[] mustAppearItems) {
        this.mustAppearItems = mustAppearItems;
    }

    public boolean itemMustAppearInPatterns(int item) {
        return this.mustAppearItems == null || Arrays.binarySearch(this.mustAppearItems, item) >= 0;
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }

    public void showSequenceIdentifiersInOutput(boolean showSequenceIdentifiers) {
        this.outputSequenceIdentifiers = showSequenceIdentifiers;
    }
}

