/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm;

import ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm.GenerateCandidates;
import ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm.SequenceList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoUHUSPM {
    int maxMemory = 0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    public static int numberOfHUSP = 0;
    public static int numberOfCandidates = 0;
    public static List<List<Itemset>> sequenceDatabase;
    Map<Integer, Integer> SWU;
    Map<Integer, Float> SWP;
    Map<Integer, Integer> orderSWU;
    Map<Integer, Float> orderSWP;
    BufferedWriter writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialDatabase(String input, int minUtility, float minProbability) throws IOException {
        String thisLine;
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            thisLine = null;
            while ((thisLine = myInput.readLine()) != null) {
                HashSet<Integer> set = new HashSet<Integer>();
                String[] arry = thisLine.split(" -1 ");
                int lineUtility = Integer.parseInt(arry[arry.length - 2]);
                float lineProbability = Float.parseFloat(arry[arry.length - 1]);
                for (int i = 0; i < arry.length - 2; ++i) {
                    String[] itemset2 = arry[i].split(" , ");
                    for (int j = 0; j < itemset2.length; ++j) {
                        String[] itemProperty = itemset2[j].split(" ");
                        int item = Integer.parseInt(itemProperty[0]);
                        set.add(item);
                    }
                }
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    int item = (Integer)it.next();
                    if (!this.SWU.containsKey(item)) {
                        this.SWU.put(item, lineUtility);
                    } else {
                        this.SWU.put(item, this.SWU.get(item) + lineUtility);
                    }
                    if (!this.SWP.containsKey(item)) {
                        this.SWP.put(item, Float.valueOf(lineProbability));
                        continue;
                    }
                    this.SWP.put(item, Float.valueOf(this.SWP.get(item).floatValue() + lineProbability));
                }
            }
        }
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            thisLine = null;
            int order = 0;
            while ((thisLine = myInput.readLine()) != null) {
                ArrayList<Itemset> sequnce = new ArrayList<Itemset>();
                String[] arry = thisLine.split(" -1 ");
                int lineSWU = Integer.parseInt(arry[arry.length - 2]);
                float lineSWP = Float.parseFloat(arry[arry.length - 1]);
                for (int i = 0; i < arry.length - 2; ++i) {
                    Itemset sitemset = new Itemset();
                    String[] itemset3 = arry[i].split(" , ");
                    for (int j = 0; j < itemset3.length; ++j) {
                        String[] itemProperty = itemset3[j].split(" ");
                        int item = Integer.parseInt(itemProperty[0]);
                        if (this.SWU.get(item) < minUtility || !(this.SWP.get(item).floatValue() >= minProbability)) continue;
                        int utility = Integer.parseInt(itemProperty[1]);
                        Item sitem = new Item();
                        sitem.item = item;
                        sitem.utility = utility;
                        sitemset.Itemset.add(sitem);
                    }
                    if (sitemset.Itemset.isEmpty()) continue;
                    sequnce.add(sitemset);
                }
                if (sequnce.isEmpty()) continue;
                sequenceDatabase.add(sequnce);
                this.orderSWU.put(order, lineSWU);
                this.orderSWP.put(order, Float.valueOf(lineSWP));
                ++order;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
    }

    List<SequenceList> initialization(String input, int minUtility, float minProbability) throws IOException {
        HashMap<Integer, SequenceList> projectSequnce = new HashMap<Integer, SequenceList>();
        this.initialDatabase(input, minUtility, minProbability);
        for (int i = 0; i < sequenceDatabase.size(); ++i) {
            int lineSWU = this.orderSWU.get(i);
            float lineProbability = this.orderSWP.get(i).floatValue();
            for (int j = 0; j < sequenceDatabase.get(i).size(); ++j) {
                for (int k = 0; k < AlgoUHUSPM.sequenceDatabase.get((int)i).get((int)j).Itemset.size(); ++k) {
                    int item = AlgoUHUSPM.sequenceDatabase.get((int)i).get((int)j).Itemset.get((int)k).item;
                    int utility = AlgoUHUSPM.sequenceDatabase.get((int)i).get((int)j).Itemset.get((int)k).utility;
                    if (!projectSequnce.containsKey(item)) {
                        SequenceList list = new SequenceList();
                        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                        itemset2.add(item);
                        list.addItemset(itemset2);
                        list.addElement(i, j, utility, lineProbability, lineSWU);
                        projectSequnce.put(item, list);
                        continue;
                    }
                    ((SequenceList)projectSequnce.get(item)).addElement(i, j, utility, lineProbability, lineSWU);
                }
            }
        }
        ArrayList<SequenceList> projectOneItemset = new ArrayList<SequenceList>(projectSequnce.values());
        for (int i = 0; i < projectOneItemset.size(); ++i) {
            ((SequenceList)projectOneItemset.get(i)).calculate();
            if (((SequenceList)projectOneItemset.get((int)i)).sumSWU >= minUtility && !(((SequenceList)projectOneItemset.get((int)i)).sumProbability < minProbability)) continue;
            projectOneItemset.remove(i);
            --i;
        }
        Collections.sort(projectOneItemset, new Comparator<SequenceList>(){

            @Override
            public int compare(SequenceList mc1, SequenceList mc2) {
                return mc1.itemsets.get(0).get(0) - mc2.itemsets.get(0).get(0);
            }
        });
        return projectOneItemset;
    }

    public void runAlgorithm(String input, String output, int minUtility, float minProbability) throws IOException, ClassNotFoundException {
        this.maxMemory = 0;
        this.startTimestamp = System.currentTimeMillis();
        numberOfCandidates = 0;
        numberOfHUSP = 0;
        this.maxMemory = 0;
        sequenceDatabase = new ArrayList<List<Itemset>>();
        this.SWU = new HashMap<Integer, Integer>();
        this.SWP = new HashMap<Integer, Float>();
        this.orderSWU = new HashMap<Integer, Integer>();
        this.orderSWP = new HashMap<Integer, Float>();
        this.writer = new BufferedWriter(new FileWriter(output));
        List<SequenceList> nextGeneration = this.initialization(input, minUtility, minProbability);
        MemoryLogger.getInstance().checkMemory();
        if (!nextGeneration.isEmpty()) {
            MemoryLogger.getInstance().checkMemory();
            nextGeneration = GenerateCandidates.generate2GenerationCandidates(nextGeneration, minUtility, minProbability, this.writer);
        }
        while (!nextGeneration.isEmpty()) {
            MemoryLogger.getInstance().checkMemory();
            nextGeneration = GenerateCandidates.generateNextGenerationCandidates(nextGeneration, minUtility, minProbability, this.writer);
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStats() throws IOException {
        System.out.println("=======  THE RESULT OF THE ALGORITHM - STATS ============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) / 1000L + " s");
        System.out.println(" Candidates count : " + numberOfCandidates);
        System.out.println(" HUSP count: " + numberOfHUSP);
        System.out.println(" Max memory: " + MemoryLogger.getInstance().getMaxMemory() + "  MB");
        System.out.println("======================================================");
    }
}

