/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm;

import ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm.AlgoUHUSPM;
import ca.pfv.spmf.algorithms.sequentialpatterns.uhuspm.SequenceList;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenerateCandidates {
    static Set<List<List<Integer>>> PSs = new HashSet<List<List<Integer>>>();
    static Map<List<List<Integer>>, Integer> USs = new HashMap<List<List<Integer>>, Integer>();

    private GenerateCandidates() {
    }

    static List<SequenceList> generate2GenerationCandidates(List<SequenceList> generation, int minUtility, float minProbability, BufferedWriter writer) throws IOException {
        int item;
        SequenceList combiner;
        SequenceList pattern2;
        int j;
        SequenceList pattern1;
        int i;
        ArrayList<SequenceList> candidates = new ArrayList<SequenceList>();
        for (SequenceList list : generation) {
            if (list.sumProbability >= minProbability) {
                PSs.add(list.itemsets);
            }
            if (list.sumUtility < minUtility || !(list.sumProbability >= minProbability)) continue;
            ++AlgoUHUSPM.numberOfHUSP;
            GenerateCandidates.writeOut(list, writer);
        }
        for (i = 0; i < generation.size(); ++i) {
            pattern1 = generation.get(i);
            for (j = i; j < generation.size(); ++j) {
                pattern2 = generation.get(j);
                combiner = new SequenceList();
                combiner.itemsets.addAll(pattern1.itemsets);
                item = pattern2.itemsets.get(0).get(0);
                combiner.addItemset(pattern2.itemsets.get(pattern2.itemsets.size() - 1));
                combiner.itemsetBasedExtend(pattern1, item, AlgoUHUSPM.sequenceDatabase);
                ++AlgoUHUSPM.numberOfCandidates;
                combiner.calculate();
                USs.put(combiner.itemsets, combiner.sumSWU);
                if (combiner.sumProbability >= minProbability) {
                    PSs.add(combiner.itemsets);
                }
                if (combiner.sumSWU >= minUtility && combiner.sumProbability >= minProbability) {
                    candidates.add(combiner);
                }
                if (pattern1 == pattern2) continue;
                SequenceList combiner2 = new SequenceList();
                ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                itemset2.addAll((Collection)pattern1.itemsets.get(0));
                itemset2.add(item);
                Collections.sort(itemset2, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer mc1, Integer mc2) {
                        return mc1 - mc2;
                    }
                });
                combiner2.itemsets.add(itemset2);
                combiner2.itemBasedExtend(pattern1, item, AlgoUHUSPM.sequenceDatabase);
                ++AlgoUHUSPM.numberOfCandidates;
                combiner2.calculate();
                USs.put(combiner2.itemsets, combiner2.sumSWU);
                if (combiner2.sumProbability >= minProbability) {
                    PSs.add(combiner2.itemsets);
                }
                if (combiner2.sumSWU < minUtility || !(combiner2.sumProbability >= minProbability)) continue;
                candidates.add(combiner2);
            }
        }
        for (i = generation.size() - 1; i >= 0; --i) {
            pattern1 = generation.get(i);
            for (j = i - 1; j >= 0; --j) {
                pattern2 = generation.get(j);
                combiner = new SequenceList();
                item = pattern2.itemsets.get(0).get(0);
                combiner.itemsets.addAll(pattern1.itemsets);
                combiner.addItemset(pattern2.itemsets.get(pattern2.itemsets.size() - 1));
                combiner.itemsetBasedExtend(pattern1, item, AlgoUHUSPM.sequenceDatabase);
                ++AlgoUHUSPM.numberOfCandidates;
                combiner.calculate();
                USs.put(combiner.itemsets, combiner.sumSWU);
                if (combiner.sumProbability >= minProbability) {
                    PSs.add(combiner.itemsets);
                }
                if (combiner.sumSWU < minUtility || !(combiner.sumProbability >= minProbability)) continue;
                candidates.add(combiner);
            }
        }
        return candidates;
    }

    static List<SequenceList> generateNextGenerationCandidates(List<SequenceList> generation, int minUtility, float minProbability, BufferedWriter writer) throws IOException {
        SequenceList candidate;
        int i;
        ArrayList<SequenceList> candidates = new ArrayList<SequenceList>();
        for (SequenceList list : generation) {
            if (list.sumUtility < minUtility || !(list.sumProbability >= minProbability)) continue;
            ++AlgoUHUSPM.numberOfHUSP;
            GenerateCandidates.writeOut(list, writer);
        }
        for (i = 0; i < generation.size(); ++i) {
            for (int j = i; j < generation.size(); ++j) {
                candidate = GenerateCandidates.combine(generation.get(i), generation.get(j), minUtility);
                if (candidate == null) continue;
                ++AlgoUHUSPM.numberOfCandidates;
                candidate.calculate();
                if (candidate.sumProbability >= minProbability) {
                    PSs.add(candidate.itemsets);
                }
                if (candidate.sumSWU < minUtility || !(candidate.sumProbability >= minProbability)) continue;
                candidates.add(candidate);
            }
        }
        for (i = generation.size() - 1; i >= 0; --i) {
            for (int j = i - 1; j >= 0; --j) {
                candidate = GenerateCandidates.combine(generation.get(i), generation.get(j), minUtility);
                if (candidate == null) continue;
                ++AlgoUHUSPM.numberOfCandidates;
                candidate.calculate();
                if (candidate.sumProbability >= minProbability) {
                    PSs.add(candidate.itemsets);
                }
                if (candidate.sumSWU < minUtility || !(candidate.sumProbability >= minProbability)) continue;
                candidates.add(candidate);
            }
        }
        return candidates;
    }

    private static SequenceList combine(SequenceList pattern1, SequenceList pattern2, int minUtility) {
        ArrayList S1 = new ArrayList();
        ArrayList S2 = new ArrayList();
        int lastItem = 0;
        for (int i = 0; i < pattern1.itemsets.size(); ++i) {
            S1.addAll(pattern1.itemsets.get(i));
        }
        S1.remove(0);
        for (int j = 0; j < pattern2.itemsets.size(); ++j) {
            S2.addAll(pattern2.itemsets.get(j));
        }
        lastItem = (Integer)S2.get(S2.size() - 1);
        S2.remove(S2.size() - 1);
        if (!S1.equals(S2)) {
            return null;
        }
        SequenceList combiner = new SequenceList();
        combiner.itemsets.addAll(pattern1.itemsets);
        if (pattern2.itemsets.get(pattern2.itemsets.size() - 1).size() >= 2) {
            ArrayList<Integer> itemset2 = new ArrayList<Integer>();
            itemset2.addAll((Collection)combiner.itemsets.get(combiner.itemsets.size() - 1));
            itemset2.add(lastItem);
            Collections.sort(itemset2, new Comparator<Integer>(){

                @Override
                public int compare(Integer mc1, Integer mc2) {
                    return mc1 - mc2;
                }
            });
            combiner.itemsets.remove(combiner.itemsets.size() - 1);
            combiner.itemsets.add(itemset2);
            if (!GenerateCandidates.EUCPProperty(combiner.itemsets, minUtility)) {
                return null;
            }
            combiner.itemBasedExtend(pattern1, lastItem, AlgoUHUSPM.sequenceDatabase);
        } else {
            combiner.itemsets.add(pattern2.itemsets.get(pattern2.itemsets.size() - 1));
            if (!GenerateCandidates.EUCPProperty(combiner.itemsets, minUtility)) {
                return null;
            }
            combiner.itemsetBasedExtend(pattern1, lastItem, AlgoUHUSPM.sequenceDatabase);
        }
        return combiner;
    }

    private static boolean DCProperty(List<List<Integer>> itemset2) throws ClassNotFoundException, IOException {
        List itemsetCopy = GenerateCandidates.deepcopy(itemset2);
        int size = itemsetCopy.size();
        for (int i = 0; i < itemsetCopy.size(); ++i) {
            for (int j = 0; j < ((List)itemsetCopy.get(i)).size(); ++j) {
                int item = (Integer)((List)itemsetCopy.get(i)).get(j);
                ((List)itemsetCopy.get(i)).remove(j);
                if (((List)itemsetCopy.get(i)).size() == 0) {
                    itemsetCopy.remove(i);
                }
                if (!PSs.contains(itemsetCopy)) {
                    return false;
                }
                if (itemsetCopy.size() == size) {
                    ((List)itemsetCopy.get(i)).add(j, item);
                    continue;
                }
                ArrayList<Integer> one = new ArrayList<Integer>();
                one.add(item);
                itemsetCopy.add(i, one);
            }
        }
        return true;
    }

    private static boolean EUCPProperty(List<List<Integer>> itemset2, int minUtility) {
        int l = itemset2.size() - 1;
        int r = itemset2.get(l).size() - 1;
        int lItem = itemset2.get(l).get(r);
        ArrayList oneTwo = new ArrayList();
        ArrayList one = new ArrayList();
        ArrayList<Integer> two = new ArrayList<Integer>();
        two.add(lItem);
        oneTwo.add(one);
        oneTwo.add(two);
        for (int i = 0; i < itemset2.size() - 1; ++i) {
            for (int j = 0; j < itemset2.get(i).size(); ++j) {
                ((List)oneTwo.get(0)).add(itemset2.get(i).get(j));
                if (USs.get(oneTwo) < minUtility) {
                    return false;
                }
                ((List)oneTwo.get(0)).remove(0);
            }
        }
        oneTwo.remove(0);
        for (int j = 0; j < r; ++j) {
            int item = itemset2.get(l).get(j);
            ((List)oneTwo.get(0)).add(0, item);
            if (USs.get(oneTwo) < minUtility) {
                return false;
            }
            ((List)oneTwo.get(0)).remove(0);
        }
        return true;
    }

    private static void writeOut(SequenceList sequence, BufferedWriter writer) throws IOException {
        for (List<Integer> items : sequence.itemsets) {
            for (int item : items) {
                writer.write(item + " ");
            }
            writer.write("-1 ");
        }
        writer.write("#UITL: ");
        writer.write(Integer.toString(sequence.sumUtility));
        writer.write(" #SP: ");
        writer.write(Float.toString(sequence.sumProbability));
        writer.newLine();
    }

    public static List deepcopy(List src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteout);
        out.writeObject(src);
        ByteArrayInputStream bytein = new ByteArrayInputStream(byteout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bytein);
        List dest = (List)in.readObject();
        return dest;
    }
}

