/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.uspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.MatrixPosition;
import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.QMatrix;
import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.QMatrixProjection;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoUSpanOLD_incomplete {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int patternCount = 0;
    BufferedWriter writer = null;
    final int BUFFERS_SIZE = 2000;
    private int[] patternBuffer = null;
    final boolean DEBUG = false;
    final boolean SAVE_RESULT_EASIER_TO_READ_FORMAT = false;
    int minUtility = 0;
    int maxPatternLength = 1000;
    String input;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.input = input;
        this.patternBuffer = new int[2000];
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minUtility = minUtility;
        HashMap<Integer, Integer> mapItemToSWU = new HashMap<Integer, Integer>();
        int sequenceCount = 0;
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] tokens = thisLine.split(" ");
                String sequenceUtilityString = tokens[tokens.length - 1];
                int positionColons = sequenceUtilityString.indexOf(58);
                int sequenceUtility = Integer.parseInt(sequenceUtilityString.substring(positionColons + 1));
                for (int i = 0; i < tokens.length - 3; ++i) {
                    String currentToken = tokens[i];
                    if (currentToken.length() == 0 || currentToken.charAt(0) == '-') continue;
                    int positionLeftBracketString = currentToken.indexOf(91);
                    String itemString = currentToken.substring(0, positionLeftBracketString);
                    Integer item = Integer.parseInt(itemString);
                    Integer swu = (Integer)mapItemToSWU.get(item);
                    swu = swu == null ? sequenceUtility : swu + sequenceUtility;
                    mapItemToSWU.put(item, swu);
                }
                ++sequenceCount;
            }
        }
        ArrayList<QMatrix> database = new ArrayList<QMatrix>(sequenceCount);
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int[] itemBuffer = new int[2000];
            int[] utilityBuffer = new int[2000];
            int[] itemsSequenceBuffer = new int[2000];
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                int itemBufferLength = 0;
                int itemsLength = 0;
                String[] tokens = thisLine.split(" ");
                String sequenceUtilityString = tokens[tokens.length - 1];
                int positionColons = sequenceUtilityString.indexOf(58);
                int sequenceUtility = Integer.parseInt(sequenceUtilityString.substring(positionColons + 1));
                int nbItemsets = 1;
                boolean currentItemsetHasAPromisingItem = false;
                for (int i = 0; i < tokens.length - 3; ++i) {
                    String currentToken = tokens[i];
                    if (currentToken.length() == 0) continue;
                    if (currentToken.equals("-1")) {
                        if (!currentItemsetHasAPromisingItem) continue;
                        itemBuffer[itemBufferLength] = -1;
                        utilityBuffer[itemBufferLength] = -1;
                        ++itemBufferLength;
                        ++nbItemsets;
                        currentItemsetHasAPromisingItem = false;
                        continue;
                    }
                    int positionLeftBracketString = currentToken.indexOf(91);
                    int positionRightBracketString = currentToken.indexOf(93);
                    String itemString = currentToken.substring(0, positionLeftBracketString);
                    Integer item = Integer.parseInt(itemString);
                    String utilityString = currentToken.substring(positionLeftBracketString + 1, positionRightBracketString);
                    Integer itemUtility = Integer.parseInt(utilityString);
                    if ((Integer)mapItemToSWU.get(item) >= minUtility) {
                        currentItemsetHasAPromisingItem = true;
                        itemBuffer[itemBufferLength] = item;
                        utilityBuffer[itemBufferLength] = itemUtility;
                        ++itemBufferLength;
                        itemsSequenceBuffer[itemsLength++] = item;
                        continue;
                    }
                    sequenceUtility -= itemUtility.intValue();
                }
                if (sequenceUtility == 0) continue;
                Arrays.sort(itemsSequenceBuffer, 0, itemsLength);
                int newItemsPos = 0;
                int lastItemSeen = -999;
                for (int i = 0; i < itemsLength; ++i) {
                    int item = itemsSequenceBuffer[i];
                    if (item == lastItemSeen) continue;
                    itemsSequenceBuffer[newItemsPos++] = item;
                    lastItemSeen = item;
                }
                int nbItems = newItemsPos;
                QMatrix matrix = new QMatrix(nbItems, nbItemsets, itemsSequenceBuffer, newItemsPos, sequenceUtility);
                database.add(matrix);
                int posBuffer = 0;
                block15: for (int itemset2 = 0; itemset2 < nbItemsets; ++itemset2) {
                    int posNames = 0;
                    while (posBuffer < itemBufferLength) {
                        int item = itemBuffer[posBuffer];
                        if (item == -1) {
                            ++posBuffer;
                            continue block15;
                        }
                        if (item == matrix.itemNames[posNames]) {
                            int utility = utilityBuffer[posBuffer];
                            matrix.registerItem(posNames, itemset2, utility, sequenceUtility -= utility);
                            ++posNames;
                            ++posBuffer;
                            continue;
                        }
                        if (item > matrix.itemNames[posNames]) {
                            matrix.registerItem(posNames, itemset2, 0, sequenceUtility);
                            ++posNames;
                            continue;
                        }
                        matrix.registerItem(posNames, itemset2, 0, sequenceUtility);
                        ++posBuffer;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.uspanFirstTime(this.patternBuffer, 0, database);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void uspanFirstTime(int[] prefix, int prefixLength, List<QMatrix> database) throws IOException {
        HashMap<Integer, Integer> mapItemSWU = new HashMap<Integer, Integer>();
        for (QMatrix qMatrix : database) {
            for (int item : qMatrix.itemNames) {
                Integer currentSWU = (Integer)mapItemSWU.get(item);
                if (currentSWU == null) {
                    mapItemSWU.put(item, qMatrix.swu);
                    continue;
                }
                mapItemSWU.put(item, currentSWU + qMatrix.swu);
            }
        }
        for (Map.Entry entry : mapItemSWU.entrySet()) {
            Integer itemSWU = (Integer)entry.getValue();
            if (itemSWU < this.minUtility) continue;
            int item = (Integer)entry.getKey();
            int totalUtility = 0;
            int totalRemainingUtility = 0;
            ArrayList<QMatrixProjection> matrixProjections = new ArrayList<QMatrixProjection>();
            for (QMatrix qmatrix : database) {
                int row = Arrays.binarySearch(qmatrix.itemNames, item);
                if (row < 0) continue;
                ArrayList<MatrixPosition> positions = new ArrayList<MatrixPosition>();
                int maxUtility = 0;
                int maxRemainingUtility = 0;
                for (int itemset2 = 0; itemset2 < qmatrix.matrixItemRemainingUtility[row].length; ++itemset2) {
                    int utility = qmatrix.matrixItemUtility[row][itemset2];
                    if (utility <= 0) continue;
                    positions.add(new MatrixPosition(row, itemset2, utility));
                    if (utility <= maxUtility) continue;
                    maxUtility = utility;
                    int remaining = qmatrix.matrixItemRemainingUtility[row][itemset2];
                    if (remaining <= 0 || maxRemainingUtility != 0) continue;
                    maxRemainingUtility = remaining;
                }
                totalUtility += maxUtility;
                totalRemainingUtility += maxRemainingUtility;
                QMatrixProjection projection = new QMatrixProjection(qmatrix, positions);
                matrixProjections.add(projection);
            }
            prefix[0] = item;
            if (totalUtility >= this.minUtility) {
                this.writeOut(prefix, 1, totalUtility);
            }
            if (totalUtility + totalRemainingUtility < this.minUtility || 1 >= this.maxPatternLength) continue;
            this.uspan(prefix, 1, matrixProjections, 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void uspan(int[] prefix, int prefixLength, List<QMatrixProjection> projectedDatabase, int itemCount) throws IOException {
        Object projection;
        int remaining;
        int newPrefixUtility;
        int newItemUtility;
        int column;
        ArrayList<MatrixPosition> positions;
        int maxRemainingUtility;
        int maxUtility;
        int totalRemainingUtility;
        int totalUtility;
        Object itemSWU;
        Pair currentSWU;
        HashMap<Integer, Pair> mapItemSWU = new HashMap<Integer, Pair>();
        for (QMatrixProjection qMatrixProjection : projectedDatabase) {
            for (MatrixPosition position : qMatrixProjection.positions) {
                int column2 = position.column;
                int localSequenceUtility = qMatrixProjection.getLocalSequenceUtility(position);
                for (int row = position.row + 1; row < qMatrixProjection.getItemNames().length; ++row) {
                    int item = qMatrixProjection.getItemNames()[row];
                    if (qMatrixProjection.getItemUtility(row, column2) <= 0) continue;
                    currentSWU = (Pair)mapItemSWU.get(item);
                    if (currentSWU == null) {
                        Pair pair = new Pair();
                        pair.lastSID = qMatrixProjection;
                        pair.swu = position.utility + localSequenceUtility;
                        mapItemSWU.put(item, pair);
                        continue;
                    }
                    if (currentSWU.lastSID != qMatrixProjection) {
                        currentSWU.lastSID = qMatrixProjection;
                        currentSWU.swu += position.utility + localSequenceUtility;
                        continue;
                    }
                    int tempSWU = position.utility + localSequenceUtility;
                    if (tempSWU <= currentSWU.swu) continue;
                    currentSWU.swu = tempSWU;
                }
            }
        }
        for (Map.Entry entry : mapItemSWU.entrySet()) {
            itemSWU = (Pair)entry.getValue();
            if (((Pair)itemSWU).swu < this.minUtility) continue;
            int item = (Integer)entry.getKey();
            totalUtility = 0;
            totalRemainingUtility = 0;
            ArrayList<QMatrixProjection> matrixProjections = new ArrayList<QMatrixProjection>();
            for (QMatrixProjection qmatrix : projectedDatabase) {
                int rowItem = Arrays.binarySearch(qmatrix.getItemNames(), item);
                if (rowItem < 0) continue;
                maxUtility = 0;
                maxRemainingUtility = 0;
                positions = new ArrayList<MatrixPosition>();
                for (MatrixPosition position : qmatrix.positions) {
                    column = position.column;
                    newItemUtility = qmatrix.getItemUtility(rowItem, column);
                    if (newItemUtility <= 0) continue;
                    newPrefixUtility = position.utility + newItemUtility;
                    positions.add(new MatrixPosition(rowItem, column, newPrefixUtility));
                    if (newPrefixUtility <= maxUtility) continue;
                    maxUtility = newPrefixUtility;
                    remaining = qmatrix.getRemainingUtility(rowItem, column);
                    if (remaining <= 0 || maxRemainingUtility != 0) continue;
                    maxRemainingUtility = remaining;
                }
                totalUtility += maxUtility;
                totalRemainingUtility += maxRemainingUtility;
                projection = new QMatrixProjection(qmatrix, positions);
                matrixProjections.add((QMatrixProjection)projection);
            }
            prefix[prefixLength] = item;
            if (totalUtility >= this.minUtility) {
                this.writeOut(prefix, prefixLength + 1, totalUtility);
            }
            if (totalUtility + totalRemainingUtility < this.minUtility || itemCount + 1 >= this.maxPatternLength) continue;
            this.uspan(prefix, prefixLength + 1, matrixProjections, itemCount + 1);
        }
        mapItemSWU.clear();
        for (QMatrixProjection qMatrixProjection : projectedDatabase) {
            for (MatrixPosition position : qMatrixProjection.positions) {
                int localSequenceUtility = qMatrixProjection.getLocalSequenceUtility(position);
                block8: for (int row = 0; row < qMatrixProjection.getItemNames().length; ++row) {
                    int item = qMatrixProjection.getItemNames()[row];
                    for (int column3 = position.column + 1; column3 < qMatrixProjection.originalMatrix.matrixItemUtility[row].length; ++column3) {
                        if (qMatrixProjection.getItemUtility(row, column3) <= 0) continue;
                        currentSWU = (Pair)mapItemSWU.get(item);
                        if (currentSWU == null) {
                            Pair pair = new Pair();
                            pair.lastSID = qMatrixProjection;
                            pair.swu = position.utility + localSequenceUtility;
                            mapItemSWU.put(item, pair);
                            continue block8;
                        }
                        if (currentSWU.lastSID != qMatrixProjection) {
                            currentSWU.lastSID = qMatrixProjection;
                            currentSWU.swu += position.utility + localSequenceUtility;
                            continue block8;
                        }
                        int tempSWU = position.utility + localSequenceUtility;
                        if (tempSWU <= currentSWU.swu) continue block8;
                        currentSWU.swu = tempSWU;
                        continue block8;
                    }
                }
            }
        }
        for (Map.Entry entry : mapItemSWU.entrySet()) {
            itemSWU = (Pair)entry.getValue();
            if (((Pair)itemSWU).swu < this.minUtility) continue;
            int item = (Integer)entry.getKey();
            totalUtility = 0;
            totalRemainingUtility = 0;
            ArrayList<QMatrixProjection> matrixProjections = new ArrayList<QMatrixProjection>();
            for (QMatrixProjection qmatrix : projectedDatabase) {
                int rowItem = Arrays.binarySearch(qmatrix.getItemNames(), item);
                if (rowItem < 0) continue;
                maxUtility = 0;
                maxRemainingUtility = 0;
                positions = new ArrayList();
                for (MatrixPosition position : qmatrix.positions) {
                    for (column = position.column + 1; column < qmatrix.originalMatrix.matrixItemUtility[rowItem].length; ++column) {
                        newItemUtility = qmatrix.getItemUtility(rowItem, column);
                        if (newItemUtility <= 0) continue;
                        newPrefixUtility = position.utility + newItemUtility;
                        positions.add(new MatrixPosition(rowItem, column, newPrefixUtility));
                        if (newPrefixUtility <= maxUtility) continue;
                        maxUtility = newPrefixUtility;
                        remaining = qmatrix.getRemainingUtility(rowItem, column);
                        if (remaining <= 0 || maxRemainingUtility != 0) continue;
                        maxRemainingUtility = remaining;
                    }
                }
                totalUtility += maxUtility;
                totalRemainingUtility += maxRemainingUtility;
                projection = new QMatrixProjection(qmatrix, positions);
                matrixProjections.add((QMatrixProjection)projection);
            }
            prefix[prefixLength] = -1;
            prefix[prefixLength + 1] = item;
            if (totalUtility >= this.minUtility) {
                this.writeOut(prefix, prefixLength + 2, totalUtility);
            }
            if (totalUtility + totalRemainingUtility < this.minUtility || itemCount + 1 >= this.maxPatternLength) continue;
            this.uspan(prefix, prefixLength + 2, matrixProjections, itemCount + 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void setMaxPatternLength(int maxPatternLength) {
        this.maxPatternLength = maxPatternLength;
    }

    private void writeOut(int[] prefix, int prefixLength, int utility) throws IOException {
        ++this.patternCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append("-1 #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfUtilityOfPatternIsCorrect(int[] prefix, int prefixLength, int utility) throws IOException {
        int calculatedUtility = 0;
        try (BufferedReader myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.input))));){
            String thisLine;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] tokens = thisLine.split(" ");
                int tokensLength = tokens.length - 3;
                int[] sequence = new int[tokensLength];
                int[] sequenceUtility = new int[tokensLength];
                for (int i = 0; i < tokensLength; ++i) {
                    int itemUtility;
                    int item;
                    String currentToken = tokens[i];
                    if (currentToken.length() == 0) continue;
                    if (currentToken.equals("-1")) {
                        item = -1;
                        itemUtility = 0;
                    } else {
                        int positionLeftBracketString = currentToken.indexOf(91);
                        int positionRightBracketString = currentToken.indexOf(93);
                        String itemString = currentToken.substring(0, positionLeftBracketString);
                        item = Integer.parseInt(itemString);
                        String utilityString = currentToken.substring(positionLeftBracketString + 1, positionRightBracketString);
                        itemUtility = Integer.parseInt(utilityString);
                    }
                    sequence[i] = item;
                    sequenceUtility[i] = itemUtility;
                }
                int util = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, 0, 0, 0);
                calculatedUtility += util;
            }
        }
        if (calculatedUtility != utility) {
            System.out.print(" ERROR, WRONG UTILITY FOR PATTERN : ");
            for (int i = 0; i < prefixLength; ++i) {
                System.out.print(prefix[i]);
            }
            System.out.println(" utility is: " + utility + " but should be: " + calculatedUtility);
        }
    }

    private int tryToMatch(int[] sequence, int[] sequenceUtility, int[] prefix, int prefixLength, int prefixPos, int seqPos, int utility) {
        ArrayList<Integer> otherUtilityValues = new ArrayList<Integer>();
        int posP = prefixPos;
        int posS = seqPos;
        int previousPrefixPos = prefixPos;
        int itemsetUtility = 0;
        while (posP < prefixLength & posS < sequence.length) {
            int otherUtility;
            if (prefix[posP] == -1 && sequence[posS] == -1) {
                otherUtility = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, previousPrefixPos, ++posS, utility);
                otherUtilityValues.add(otherUtility);
                utility += itemsetUtility;
                itemsetUtility = 0;
                previousPrefixPos = ++posP;
                continue;
            }
            if (prefix[posP] == -1) {
                while (posS < sequence.length && sequence[posS] != -1) {
                    ++posS;
                }
                otherUtility = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, previousPrefixPos, posS, utility);
                otherUtilityValues.add(otherUtility);
                utility += itemsetUtility;
                itemsetUtility = 0;
                previousPrefixPos = posP;
                continue;
            }
            if (sequence[posS] == -1) {
                posP = previousPrefixPos;
                itemsetUtility = 0;
                ++posS;
                continue;
            }
            if (prefix[posP] == sequence[posS]) {
                itemsetUtility += sequenceUtility[posS];
                ++posS;
                if (++posP != prefixLength) continue;
                while (posS < sequence.length && sequence[posS] != -1) {
                    ++posS;
                }
                otherUtility = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, previousPrefixPos, posS, utility);
                otherUtilityValues.add(otherUtility);
                utility += itemsetUtility;
                continue;
            }
            if (prefix[posP] == sequence[posS]) continue;
            ++posS;
        }
        int max = 0;
        if (posP == prefixLength) {
            max = utility;
        }
        Iterator iterator = otherUtilityValues.iterator();
        while (iterator.hasNext()) {
            int utilValue = (Integer)iterator.next();
            if (utilValue <= utility) continue;
            max = utilValue;
        }
        return max;
    }

    public void printStatistics() {
        System.out.println("=============  USPAN ALGORITHM v2.14 - STATS ==========");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility sequential pattern count : " + this.patternCount);
        System.out.println("========================================================");
    }

    private class Pair {
        int swu;
        QMatrixProjection lastSID;

        private Pair() {
        }
    }
}

