/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.differencing;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoFirstOrderDifferencing {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries) throws IOException {
        if (timeSeries.size() < 2) {
            throw new IllegalArgumentException(" The time series should contain at least 2 points to apply differencing.");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] resultTimeSeriesArray = this.calculateFirstOrderDifferencing(timeSeries.data);
        TimeSeries transformedTimeSeries = new TimeSeries(resultTimeSeriesArray, timeSeries.getName() + "_FODIFF");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return transformedTimeSeries;
    }

    private double[] calculateFirstOrderDifferencing(double[] timeSeries) {
        double[] result = new double[timeSeries.length - 1];
        for (int i = 1; i < timeSeries.length; ++i) {
            result[i - 1] = timeSeries[i] - timeSeries[i - 1];
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" First order differencing: " + Arrays.toString(result));
        }
        return result;
    }

    public void printStats() {
        System.out.println("=============  First order differencing transformation v2.21- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

