/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.exponentialsmoothing;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoExponentialSmoothing {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries, double alpha) throws IOException {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException(" The alpha constant should be a value in the [0,1] interval");
        }
        if (timeSeries.size() <= 1) {
            throw new IllegalArgumentException(" The time series should contain at least 2 points to apply exponential smoothing.");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] transformedTimeSeriesArray = this.calculateExponentialSmoothing(timeSeries.data, alpha);
        TimeSeries transformedTimeSeries = new TimeSeries(transformedTimeSeriesArray, timeSeries.getName() + "_EXPSTHG");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return transformedTimeSeries;
    }

    private double[] calculateExponentialSmoothing(double[] timeSeries, double alpha) {
        double[] exponentialSmoothing = new double[timeSeries.length];
        exponentialSmoothing[0] = timeSeries[0];
        for (int i = 1; i < timeSeries.length; ++i) {
            exponentialSmoothing[i] = timeSeries[i] * alpha + exponentialSmoothing[i - 1] * (1.0 - alpha);
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Alpha = " + alpha);
            System.out.println(" Exponential smoothing transformation: " + Arrays.toString(exponentialSmoothing));
        }
        return exponentialSmoothing;
    }

    public void printStats() {
        System.out.println("=============  Transform to Exponential Smoothing v2.21- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

