/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.movingaverage;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoCentralMovingAverage {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries, int windowSize) throws IOException {
        if (windowSize >= timeSeries.data.length || windowSize < 3 || windowSize % 2 != 1) {
            throw new IllegalArgumentException(" The window size must be odd, greater than 1, and no larger than the number of points in the time series");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] movingAverageData = this.calculateCentralMovingAverage(timeSeries.data, windowSize);
        TimeSeries movingAverage = new TimeSeries(movingAverageData, timeSeries.getName() + "_CEMAVG");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return movingAverage;
    }

    private double[] calculateCentralMovingAverage(double[] timeSeries, int windowSize) {
        int j;
        double[] movingAverage = new double[timeSeries.length];
        int alpha = (windowSize - 1) / 2;
        double sum = 0.0;
        for (int i = 0; i <= alpha; ++i) {
            sum += timeSeries[i];
        }
        movingAverage[0] = sum / (double)(alpha + 1);
        for (j = 1; j <= alpha; ++j) {
            movingAverage[j] = (sum += timeSeries[j + alpha]) / (double)(alpha + 1 + j);
        }
        for (j = alpha + 1; j < timeSeries.length - alpha; ++j) {
            sum += timeSeries[j + alpha];
            movingAverage[j] = (sum -= timeSeries[j - alpha - 1]) / (double)windowSize;
        }
        int pointsRemoved = 0;
        for (int j2 = timeSeries.length - alpha; j2 < timeSeries.length; ++j2) {
            movingAverage[j2] = (sum -= timeSeries[j2 - alpha - 1]) / (double)(windowSize - ++pointsRemoved);
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Window size = " + windowSize);
            System.out.println(" Central Moving average transformation: " + Arrays.toString(movingAverage));
        }
        return movingAverage;
    }

    public void printStats() {
        System.out.println("=============  Transform to Central Moving Average v2.21 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

