/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.reader_writer;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AlgoTimeSeriesReader {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;
    int timeSeriesCount = 0;

    public List<TimeSeries> runAlgorithm(String input, String separator) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        ArrayList<TimeSeries> multipleTimeSeries = new ArrayList<TimeSeries>();
        BufferedReader myInput = null;
        this.timeSeriesCount = 0;
        if (this.DEBUG_MODE) {
            System.out.println(System.lineSeparator() + "======= READING THE INPUT FILE =======");
        }
        String currentTimeSeriesName = null;
        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
        while ((thisLine = myInput.readLine()) != null) {
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%') continue;
            if (thisLine.charAt(0) == '@') {
                if (!thisLine.startsWith("@NAME=")) continue;
                currentTimeSeriesName = thisLine.substring(6, thisLine.length());
                continue;
            }
            if (this.DEBUG_MODE) {
                System.out.println(System.lineSeparator() + "--- Reading time series #" + (this.timeSeriesCount + 1) + " ---");
            }
            String[] tokens = thisLine.split(separator);
            double[] dataPoints = ArraysAlgos.convertStringArrayToDoubleArray(tokens);
            String nameToUse = currentTimeSeriesName == null ? "Series " + this.timeSeriesCount : currentTimeSeriesName;
            currentTimeSeriesName = null;
            multipleTimeSeries.add(new TimeSeries(dataPoints, nameToUse));
            ++this.timeSeriesCount;
        }
        this.timeSeriesCount = multipleTimeSeries.size();
        myInput.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return multipleTimeSeries;
    }

    public void printStats() {
        System.out.println("======= READ TIME SERIES TO MEMORY v2.07- STATS =======");
        System.out.println(" Number of time series processed: " + this.timeSeriesCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================================================");
    }
}

