/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.sax;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.sax.AlgoSAX;
import ca.pfv.spmf.algorithms.timeseries.sax.SAXSymbol;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class AlgoConvertTimeSeriesFileToSequencesWithSAX {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    BufferedWriter writer = null;
    boolean DEBUG_MODE = false;
    int timeSeriesCount = 0;
    SAXSymbol[] symbols;

    public void runAlgorithm(List<TimeSeries> multipleTimeSeries, String output, int numberOfSegments, int numberOfSymbols, boolean deactivatePAA) throws IOException {
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.writer.write("@CONVERTED_FROM_TIME_SERIES");
        this.timeSeriesCount = multipleTimeSeries.size();
        if (this.DEBUG_MODE) {
            System.out.println(System.lineSeparator() + "======= READING THE INPUT FILE =======");
        }
        if (this.DEBUG_MODE) {
            for (TimeSeries timeSeries : multipleTimeSeries) {
                System.out.println(System.lineSeparator() + "--- Reading time series #" + (this.timeSeriesCount + 1) + " ---");
            }
        }
        if (this.DEBUG_MODE) {
            System.out.println(System.lineSeparator() + "======= APPLYING SAX  ========" + System.lineSeparator());
        }
        AlgoSAX algo = new AlgoSAX();
        SAXSymbol[][] saxSequences = algo.runAlgorithm(multipleTimeSeries, numberOfSegments, numberOfSymbols, deactivatePAA);
        if (this.DEBUG_MODE) {
            System.out.println("======= WRITING THE OUTPUT FILE  ========" + System.lineSeparator());
        }
        this.symbols = algo.getSymbols();
        this.writeSAXSymbolsToOutputFile(this.symbols);
        for (int i = 0; i < multipleTimeSeries.size(); ++i) {
            TimeSeries timeSeries = multipleTimeSeries.get(i);
            SAXSymbol[] saxSequence = saxSequences[i];
            this.writeSAXRepresentationToOutputFile(saxSequence, timeSeries.getName());
        }
        this.timeSeriesCount = multipleTimeSeries.size();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    public SAXSymbol[] getSymbols() {
        return this.symbols;
    }

    private void writeSAXRepresentationToOutputFile(SAXSymbol[] saxRepresentation, String name) throws IOException {
        this.writer.newLine();
        this.writer.write("@NAME=" + name);
        this.writer.newLine();
        for (SAXSymbol symbol : saxRepresentation) {
            this.writer.write(symbol.symbol + " -1 ");
        }
        this.writer.write("-2");
    }

    private void writeSAXSymbolsToOutputFile(SAXSymbol[] symbols) throws IOException {
        for (SAXSymbol symbol : symbols) {
            this.writer.newLine();
            this.writer.append("@ITEM=" + symbol.symbol + "=[" + symbol.lowerBound + "," + symbol.upperBound + "]");
        }
    }

    public void printStats() {
        System.out.println("======= CONVERT TIME SERIES TO SEQUENCES WITH SAX v2.05- STATS =======");
        System.out.println(" Number of time series processed: " + this.timeSeriesCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================================================");
    }
}

