/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.simplelinearregression;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.Arrays;

public class AlgoTimeSeriesLinearRegressionLeastSquare {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;
    double bias = 0.0;
    double coefficient = 0.0;

    public void trainModel(TimeSeries timeSeries) {
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        this.trainRegressionModel(timeSeries.data);
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public TimeSeries calculateRegressionLine(TimeSeries series) {
        double[] timeSeries = series.data;
        double[] regressionLine = new double[timeSeries.length];
        for (int i = 0; i < timeSeries.length; ++i) {
            regressionLine[i] = this.performPrediction(i);
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Time-series obtained by the regression: " + Arrays.toString(regressionLine));
        }
        return new TimeSeries(regressionLine, series.getName() + "_LR");
    }

    private void trainRegressionModel(double[] timeSeries) {
        double sumXvalues = 0.0;
        for (int i = 0; i < timeSeries.length; ++i) {
            sumXvalues += timeSeries[i];
        }
        double averageXvalues = sumXvalues / (double)timeSeries.length;
        double sumYvalues = 0.0;
        for (int i = 0; i < timeSeries.length; ++i) {
            sumYvalues += (double)i;
        }
        double averageYvalues = sumYvalues / (double)timeSeries.length;
        double sumOfErrorsXwithX = 0.0;
        double sumOfErrorsXwithY = 0.0;
        for (int i = 0; i < timeSeries.length; ++i) {
            double xi = timeSeries[i];
            double difference = xi - averageXvalues;
            sumOfErrorsXwithX += difference * difference;
            double yi = i;
            sumOfErrorsXwithY += difference * (yi - averageYvalues);
        }
        this.coefficient = sumOfErrorsXwithY / sumOfErrorsXwithX;
        this.bias = averageYvalues - this.coefficient * averageXvalues;
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Regression line is: ");
            System.out.println("  Y(x) = " + this.bias + " + " + this.coefficient + " * x");
        }
    }

    public double performPrediction(double x) {
        return this.bias + x * this.coefficient;
    }

    public double getBias() {
        return this.bias;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public void printStats() {
        System.out.println("=============  Linear regression (least squares) v2.19- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

