/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.standardization;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoStandardization {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries) throws IOException {
        if (timeSeries.size() < 1) {
            throw new IllegalArgumentException(" The time series should contain at least 1 point.");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] resultTimeSeriesArray = this.calculateStandardization(timeSeries.data);
        TimeSeries transformedTimeSeries = new TimeSeries(resultTimeSeriesArray, timeSeries.getName() + "_STDDZ");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return transformedTimeSeries;
    }

    private double[] calculateStandardization(double[] timeSeries) {
        int i;
        double[] result = new double[timeSeries.length];
        double mean = 0.0;
        for (int i2 = 0; i2 < timeSeries.length; ++i2) {
            mean += timeSeries[i2];
        }
        mean /= (double)timeSeries.length;
        double standardDeviation = 0.0;
        for (i = 0; i < timeSeries.length; ++i) {
            standardDeviation += Math.pow(timeSeries[i] - mean, 2.0);
        }
        standardDeviation = Math.sqrt(standardDeviation / (double)timeSeries.length);
        for (i = 0; i < timeSeries.length; ++i) {
            result[i] = (timeSeries[i] - mean) / standardDeviation;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Standardization: " + Arrays.toString(result));
        }
        return result;
    }

    public void printStats() {
        System.out.println("=============  Standardization transformation v2.21- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

