/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.datastructures.kdtree;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceEuclidian;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.datastructures.kdtree.KDNode;
import ca.pfv.spmf.datastructures.kdtree.KNNPoint;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class KDTree {
    private int nodeCount = 0;
    private KDNode root = null;
    int dimensionCount = 0;
    private static Random random = new Random(System.currentTimeMillis());
    DistanceFunction distanceFunction = new DistanceEuclidian();
    DoubleArray nearestNeighboor = null;
    double minDist = 0.0;
    RedBlackTree<KNNPoint> resultKNN = null;
    int k = 0;

    public int size() {
        return this.nodeCount;
    }

    public void buildtree(List<DoubleArray> points) {
        if (points.size() == 0) {
            return;
        }
        this.dimensionCount = points.get(0).size();
        this.root = this.generateNode(0, points, 0, points.size() - 1);
    }

    private KDNode generateNode(int currentD, List<DoubleArray> points, int left, int right) {
        if (right < left) {
            return null;
        }
        ++this.nodeCount;
        if (right == left) {
            return new KDNode(points.get(left), currentD);
        }
        int m = (right - left) / 2;
        DoubleArray medianNode = this.randomizedSelect(points, m, left, right, currentD);
        KDNode node = new KDNode(medianNode, currentD);
        if (++currentD == this.dimensionCount) {
            currentD = 0;
        }
        node.below = this.generateNode(currentD, points, left, left + m - 1);
        node.above = this.generateNode(currentD, points, left + m + 1, right);
        return node;
    }

    private DoubleArray randomizedSelect(List<DoubleArray> points, int i, int left, int right, int currentD) {
        int p = left;
        int r = right;
        while (p != r) {
            int q = this.randomizedPartition(points, p, r, currentD);
            int k = q - p + 1;
            if (i == k - 1) {
                return points.get(q);
            }
            if (i < k) {
                r = q - 1;
                continue;
            }
            i -= k;
            p = q + 1;
        }
        return points.get(p);
    }

    private int randomizedPartition(List<DoubleArray> points, int p, int r, int currentD) {
        int i = 0;
        i = p < r ? p + random.nextInt(r - p) : r + random.nextInt(p - r);
        this.swap(points, r, i);
        return this.partition(points, p, r, currentD);
    }

    private int partition(List<DoubleArray> points, int p, int r, int currentD) {
        DoubleArray x = points.get(r);
        int i = p - 1;
        for (int j = p; j <= r - 1; ++j) {
            if (!(points.get((int)j).data[currentD] <= x.data[currentD])) continue;
            this.swap(points, ++i, j);
        }
        this.swap(points, i + 1, r);
        return i + 1;
    }

    private void swap(List<DoubleArray> points, int i, int j) {
        DoubleArray valueI = points.get(i);
        points.set(i, points.get(j));
        points.set(j, valueI);
    }

    public DoubleArray nearest(DoubleArray targetPoint) {
        if (this.root == null) {
            return null;
        }
        this.findParent(targetPoint, this.root, 0);
        this.nearest(this.root, targetPoint);
        return this.nearestNeighboor;
    }

    private void findParent(DoubleArray target, KDNode node, int d) {
        if (target.data[d] < node.values.data[d]) {
            if (++d == this.dimensionCount) {
                d = 0;
            }
            if (node.below == null) {
                this.nearestNeighboor = node.values;
                this.minDist = this.distanceFunction.calculateDistance(node.values, target);
                return;
            }
            this.findParent(target, node.below, d);
        }
        if (++d == this.dimensionCount) {
            d = 0;
        }
        if (node.above == null) {
            this.nearestNeighboor = node.values;
            this.minDist = this.distanceFunction.calculateDistance(node.values, target);
            return;
        }
        this.findParent(target, node.above, d);
    }

    private void nearest(KDNode node, DoubleArray targetPoint) {
        double perpendicularyDistance;
        int dMinus1;
        double d = this.distanceFunction.calculateDistance(node.values, targetPoint);
        if (d < this.minDist) {
            this.minDist = d;
            this.nearestNeighboor = node.values;
        }
        if ((dMinus1 = node.d - 1) < 0) {
            dMinus1 = this.dimensionCount - 1;
        }
        if ((perpendicularyDistance = Math.abs(node.values.data[node.d] - targetPoint.data[node.d])) < this.minDist) {
            if (node.above != null) {
                this.nearest(node.above, targetPoint);
            }
            if (node.below != null) {
                this.nearest(node.below, targetPoint);
            }
        } else if (targetPoint.data[dMinus1] < node.values.data[dMinus1]) {
            if (node.below != null) {
                this.nearest(node.below, targetPoint);
            }
        } else if (node.above != null) {
            this.nearest(node.above, targetPoint);
        }
    }

    public RedBlackTree<KNNPoint> knearest(DoubleArray targetPoint, int k) {
        this.k = k;
        this.resultKNN = new RedBlackTree();
        if (this.root == null) {
            return null;
        }
        this.findParent_knn(targetPoint, this.root, 0);
        this.nearest_knn(this.root, targetPoint);
        return this.resultKNN;
    }

    private void findParent_knn(DoubleArray target, KDNode node, int d) {
        if (target.data[d] < node.values.data[d]) {
            if (++d == this.dimensionCount) {
                d = 0;
            }
            if (node.below == null) {
                this.tryToSave(node, target);
                return;
            }
            this.tryToSave(node.below, target);
            this.findParent_knn(target, node.below, d);
        }
        if (++d == this.dimensionCount) {
            d = 0;
        }
        if (node.above == null) {
            this.tryToSave(node, target);
            return;
        }
        this.tryToSave(node.above, target);
        this.findParent_knn(target, node.above, d);
    }

    private void tryToSave(KDNode node, DoubleArray target) {
        if (node == null) {
            return;
        }
        double distance = this.distanceFunction.calculateDistance(target, node.values);
        if (this.resultKNN.size() == this.k && this.resultKNN.maximum().distance < distance) {
            return;
        }
        KNNPoint point = new KNNPoint(node.values, distance);
        if (this.resultKNN.contains(point)) {
            return;
        }
        this.resultKNN.add(point);
        if (this.resultKNN.size() > this.k) {
            this.resultKNN.popMaximum();
        }
    }

    private void nearest_knn(KDNode node, DoubleArray targetPoint) {
        this.tryToSave(node, targetPoint);
        double perpendicularDistance = Math.abs(node.values.data[node.d] - targetPoint.data[node.d]);
        if (perpendicularDistance < this.resultKNN.maximum().distance) {
            if (node.above != null) {
                this.nearest_knn(node.above, targetPoint);
            }
            if (node.below != null) {
                this.nearest_knn(node.below, targetPoint);
            }
        } else if (targetPoint.data[node.d] < node.values.data[node.d]) {
            if (node.below != null) {
                this.nearest_knn(node.below, targetPoint);
            }
        } else if (node.above != null) {
            this.nearest_knn(node.above, targetPoint);
        }
    }

    public List<DoubleArray> pointsWithinRadiusOf(DoubleArray targetPoint, double radius) {
        ArrayList<DoubleArray> result = new ArrayList<DoubleArray>();
        return this.pointsWithinRadiusOf(targetPoint, radius, result);
    }

    public List<DoubleArray> pointsWithinRadiusOf(DoubleArray targetPoint, double radius, List<DoubleArray> result) {
        if (this.root == null) {
            return null;
        }
        this.findPointsWithinRadius(this.root, targetPoint, result, radius);
        return result;
    }

    private void findPointsWithinRadius(KDNode node, DoubleArray targetPoint, List<DoubleArray> result, double radius) {
        double perpendicularDistance;
        if (node.values != targetPoint) {
            this.tryToSaveRadius(node, targetPoint, result, radius);
        }
        if ((perpendicularDistance = Math.abs(node.values.data[node.d] - targetPoint.data[node.d])) < radius) {
            if (node.above != null) {
                this.findPointsWithinRadius(node.above, targetPoint, result, radius);
            }
            if (node.below != null) {
                this.findPointsWithinRadius(node.below, targetPoint, result, radius);
            }
        } else if (targetPoint.data[node.d] < node.values.data[node.d]) {
            if (node.below != null) {
                this.findPointsWithinRadius(node.below, targetPoint, result, radius);
            }
        } else if (node.above != null) {
            this.findPointsWithinRadius(node.above, targetPoint, result, radius);
        }
    }

    private void tryToSaveRadius(KDNode node, DoubleArray target, List<DoubleArray> result, double radius) {
        if (node == null) {
            return;
        }
        double distance = this.distanceFunction.calculateDistance(target, node.values);
        if (distance <= radius) {
            result.add(node.values);
        }
    }

    public List<KNNPoint> pointsWithinRadiusOfWithDistance(DoubleArray targetPoint, double radius) {
        if (this.root == null) {
            return null;
        }
        ArrayList<KNNPoint> result = new ArrayList<KNNPoint>();
        return this.pointsWithinRadiusOfWithDistance(targetPoint, radius, result);
    }

    public List<KNNPoint> pointsWithinRadiusOfWithDistance(DoubleArray targetPoint, double radius, List<KNNPoint> result) {
        if (this.root == null) {
            return null;
        }
        this.findPointsWithinRadiusWithDistance(this.root, targetPoint, result, radius);
        return result;
    }

    private void findPointsWithinRadiusWithDistance(KDNode node, DoubleArray targetPoint, List<KNNPoint> result, double radius) {
        double perpendicularDistance;
        if (node.values != targetPoint) {
            this.tryToSaveRadiusWithDistance(node, targetPoint, result, radius);
        }
        if ((perpendicularDistance = Math.abs(node.values.data[node.d] - targetPoint.data[node.d])) < radius) {
            if (node.above != null) {
                this.findPointsWithinRadiusWithDistance(node.above, targetPoint, result, radius);
            }
            if (node.below != null) {
                this.findPointsWithinRadiusWithDistance(node.below, targetPoint, result, radius);
            }
        } else if (targetPoint.data[node.d] < node.values.data[node.d]) {
            if (node.below != null) {
                this.findPointsWithinRadiusWithDistance(node.below, targetPoint, result, radius);
            }
        } else if (node.above != null) {
            this.findPointsWithinRadiusWithDistance(node.above, targetPoint, result, radius);
        }
    }

    private void tryToSaveRadiusWithDistance(KDNode node, DoubleArray target, List<KNNPoint> result, double radius) {
        double distance;
        if (node != null && (distance = this.distanceFunction.calculateDistance(target, node.values)) <= radius) {
            result.add(new KNNPoint(node.values, distance));
        }
    }

    private String toString(double[] values) {
        StringBuilder buffer = new StringBuilder();
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double element = dArray[i];
            buffer.append(" " + element);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toString(this.root, " ");
    }

    private String toString(KDNode node, String indent) {
        if (node == null) {
            return "";
        }
        String newIndent1 = indent + "   |";
        String newIndent2 = indent + "   |";
        return node.values + " (" + node.d + ") \n" + indent + this.toString(node.above, newIndent1) + "\n" + indent + this.toString(node.below, newIndent2);
    }
}

