/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import ca.pfv.spmf.algorithmmanager.AlgorithmManager;
import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.gui.CommandProcessor;
import ca.pfv.spmf.gui.MainWindow;
import java.lang.reflect.Method;

public class Main {
    public static final String SPMF_VERSION = "2.42c";

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            Main.processCommandLineArguments(args);
        } else {
            MainWindow mainWindow = new MainWindow(true, true);
            mainWindow.setVisible(true);
        }
    }

    public static void processCommandLineArguments(String[] args) {
        if ("version".equals(args[0])) {
            System.out.println(" \n-- SPMF version 2.42c --\n");
        } else if ("help".equals(args[0])) {
            System.out.println("\n\nFor help, please check the documentation section of the SPMF website: http://philippe-fournier-viger.com/spmf/ \n\n");
        } else if ("run".equals(args[0])) {
            try {
                String[] parameters;
                String algoName = null;
                if (args.length > 1) {
                    algoName = args[1];
                }
                DescriptionOfAlgorithm description = AlgorithmManager.getInstance().getDescriptionOfAlgorithm(algoName);
                int i = 2;
                String input = null;
                if (description.getInputFileTypes() != null) {
                    if (args.length > i) {
                        input = args[i];
                    }
                    ++i;
                }
                String output = null;
                if (description.getOutputFileTypes() != null) {
                    if (args.length > i) {
                        output = args[i];
                    }
                    ++i;
                }
                if (args.length > i) {
                    parameters = new String[args.length - i];
                    System.arraycopy(args, i, parameters, 0, args.length - i);
                } else {
                    parameters = new String[]{};
                }
                CommandProcessor.runAlgorithm(algoName, input, output, parameters);
            }
            catch (NumberFormatException e) {
                System.out.println("Error. Please check the parameters of the algorithm.  The format for numbers is incorrect. \n\n ERROR MESSAGE = " + e.toString());
            }
            catch (Exception e) {
                System.out.println("An error while trying to run the algorithm. \n ERROR MESSAGE = " + e.toString());
                e.printStackTrace();
            }
        } else if ("test".equals(args[0])) {
            String testName = args[1];
            try {
                Class<?> testClass = Class.forName("ca.pfv.spmf.tests." + testName);
                Method mainMethod = testClass.getMethod("main", String[].class);
                Object params = null;
                mainMethod.invoke(null, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\n\n Command not recognized.\n For help, please check the documentation section of the SPMF website: http://philippe-fournier-viger.com/spmf/ \n \n");
        }
    }
}

