/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.clusterviewer;

import ca.pfv.spmf.gui.clusterviewer.ClusterViewerPanel;
import ca.pfv.spmf.gui.clusterviewer.ClusterViewerPanelListener;
import ca.pfv.spmf.gui.plot.Plot;
import ca.pfv.spmf.patterns.cluster.Cluster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;

public class ClusterViewer
extends JFrame
implements ClusterViewerPanelListener {
    String title = "SPMF Cluster Viewer 2.09";
    private static final long serialVersionUID = 1L;
    ClusterViewerPanel panelChart = null;
    private JLabel labelX;
    private JLabel labelY;
    private JLabel labelName;
    String[] attributeNamesArray = null;
    private JComboBox comboBoxX;
    private JComboBox comboBoxY;

    public ClusterViewer(List<Cluster> clusters, List<String> attributeNames) {
        if (clusters.size() == 0) {
            JOptionPane.showMessageDialog(null, "The file is empty. The instance viewer has nothing to display", "Error", 0);
        }
        this.attributeNamesArray = attributeNames.toArray(new String[0]);
        if (attributeNames == null || attributeNames.size() == 0) {
            int dimensionCount = clusters.get((int)0).getVectors().get((int)0).data.length;
            this.attributeNamesArray = new String[dimensionCount];
            for (int i = 0; i < dimensionCount; ++i) {
                attributeNames.add("Attribute " + i);
            }
        }
        this.setTitle(this.title);
        this.setSize(900, 687);
        this.setMinimumSize(new Dimension(884, 648));
        this.panelChart = new ClusterViewerPanel(clusters, 0, 1);
        this.panelChart.setForeground(Color.WHITE);
        this.panelChart.addListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JScrollPane scrollPane = new JScrollPane(this.panelChart);
        scrollPane.setAutoscrolls(true);
        this.getContentPane().add(scrollPane);
        JPanel panelTools = new JPanel();
        panelTools.setMinimumSize(new Dimension(900, 120));
        panelTools.setPreferredSize(new Dimension(900, 120));
        panelTools.setMaximumSize(new Dimension(900, 120));
        this.getContentPane().add(panelTools);
        panelTools.setLayout(null);
        JPanel panel = new JPanel();
        panel.setBounds(15, 16, 199, 55);
        panelTools.add(panel);
        panel.setBorder(new EtchedBorder(1, null, null));
        panel.setVisible(true);
        panel.setLayout(null);
        this.labelX = new JLabel("x = ");
        this.labelX.setBounds(15, 7, 61, 20);
        panel.add(this.labelX);
        this.labelY = new JLabel("y = ");
        this.labelY.setBounds(104, 7, 51, 20);
        panel.add(this.labelY);
        this.labelName = new JLabel("name = ");
        this.labelName.setBounds(15, 27, 169, 20);
        panel.add(this.labelName);
        JButton buttonZoomIn = new JButton("");
        buttonZoomIn.setBounds(218, 16, 50, 29);
        panelTools.add(buttonZoomIn);
        buttonZoomIn.setIcon(new ImageIcon(ClusterViewer.class.getResource("/ca/pfv/spmf/gui/icons/zoomin.gif")));
        JButton buttonZoomOut = new JButton("");
        buttonZoomOut.setBounds(270, 16, 50, 29);
        panelTools.add(buttonZoomOut);
        buttonZoomOut.setIcon(new ImageIcon(ClusterViewer.class.getResource("/ca/pfv/spmf/gui/icons/zoomout.gif")));
        JLabel lblLegend = new JLabel("Legend:");
        lblLegend.setBounds(353, 25, 59, 20);
        panelTools.add(lblLegend);
        final JComboBox<Plot.LegendFormat> comboBoxLegend = new JComboBox<Plot.LegendFormat>(Plot.LegendFormat.values());
        comboBoxLegend.setBounds(416, 19, 87, 26);
        panelTools.add(comboBoxLegend);
        comboBoxLegend.setSelectedIndex(3);
        final JComboBox<String> comboBoxGrid = new JComboBox<String>(new String[]{"VISIBLE", "NONE"});
        comboBoxGrid.setBounds(592, 19, 87, 26);
        panelTools.add(comboBoxGrid);
        comboBoxGrid.setSelectedIndex(1);
        JLabel lblGrid = new JLabel("Grid:");
        lblGrid.setBounds(533, 25, 44, 20);
        panelTools.add(lblGrid);
        JLabel lblMarkers = new JLabel("Markers:");
        lblMarkers.setBounds(517, 59, 70, 20);
        panelTools.add(lblMarkers);
        final JComboBox<String> comboBoxMarkers = new JComboBox<String>(new String[]{"NONE", "1 pts", "2 pts", "3 pts", "4 pts", "5 pts", "6 pts", "7 pts", "8 pts", "9 pts", "10 pts"});
        comboBoxMarkers.setSelectedIndex(5);
        comboBoxMarkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selection = comboBoxMarkers.getSelectedIndex();
                ClusterViewer.this.panelChart.setMarkersSize(selection);
            }
        });
        comboBoxMarkers.setBounds(592, 53, 87, 26);
        panelTools.add(comboBoxMarkers);
        JButton buttonSaveAsPng = new JButton("Save as PNG");
        buttonSaveAsPng.setBounds(694, 50, 163, 29);
        panelTools.add(buttonSaveAsPng);
        buttonSaveAsPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClusterViewer.this.panelChart.export();
            }
        });
        buttonSaveAsPng.setIcon(new ImageIcon(ClusterViewer.class.getResource("/ca/pfv/spmf/gui/icons/save.gif")));
        JButton buttonPrint = new JButton("Print");
        buttonPrint.setBounds(694, 16, 163, 29);
        panelTools.add(buttonPrint);
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClusterViewer.this.panelChart.doPrint();
            }
        });
        buttonPrint.setIcon(new ImageIcon(ClusterViewer.class.getResource("/ca/pfv/spmf/gui/icons/print.gif")));
        this.comboBoxX = new JComboBox<String>(this.attributeNamesArray);
        this.comboBoxX.setSelectedIndex(0);
        this.comboBoxX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int attributeSelectedX = ClusterViewer.this.comboBoxX.getSelectedIndex();
                int attributeSelectedY = ClusterViewer.this.comboBoxY.getSelectedIndex();
                ClusterViewer.this.panelChart.setAttributeSelection(attributeSelectedX, attributeSelectedY);
            }
        });
        this.comboBoxX.setBounds(92, 82, 121, 20);
        panelTools.add(this.comboBoxX);
        this.comboBoxY = new JComboBox<String>(this.attributeNamesArray);
        this.comboBoxY.setSelectedIndex(1);
        this.comboBoxY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int attributeSelectedX = ClusterViewer.this.comboBoxX.getSelectedIndex();
                int attributeSelectedY = ClusterViewer.this.comboBoxY.getSelectedIndex();
                ClusterViewer.this.panelChart.setAttributeSelection(attributeSelectedX, attributeSelectedY);
            }
        });
        this.comboBoxY.setBounds(299, 82, 121, 20);
        panelTools.add(this.comboBoxY);
        JLabel label = new JLabel("X attribute:");
        label.setBounds(25, 85, 75, 14);
        panelTools.add(label);
        JLabel label_1 = new JLabel("Y attribute:");
        label_1.setBounds(223, 85, 70, 14);
        panelTools.add(label_1);
        comboBoxGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = (String)comboBoxGrid.getSelectedItem();
                ClusterViewer.this.panelChart.setDrawGrid("VISIBLE".equals(selection));
            }
        });
        comboBoxLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.LegendFormat selection = (Plot.LegendFormat)((Object)comboBoxLegend.getSelectedItem());
                ClusterViewer.this.panelChart.setDrawLegend(selection);
            }
        });
        buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClusterViewer.this.panelChart.decreaseZoom();
            }
        });
        buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClusterViewer.this.panelChart.increaseZoom();
            }
        });
    }

    @Override
    public void notifyOfNewMousePosition(double x, double y, Color colorUnderMouse, String objectUnderMouse) {
        DecimalFormat df = new DecimalFormat("0.00");
        df.setMaximumFractionDigits(2);
        String stringX = df.format(x);
        String stringY = df.format(y);
        this.labelX.setText("x = " + stringX);
        this.labelY.setText("y = " + stringY);
        this.labelName.setText("Name = " + objectUnderMouse);
        if (!"".equals(objectUnderMouse)) {
            this.labelName.setForeground(colorUnderMouse);
        } else {
            this.labelName.setForeground(Color.black);
        }
    }

    @Override
    public void notifyMouseOutOfChart() {
        this.labelX.setText("x = ");
        this.labelY.setText("y = ");
    }
}

