/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.clusterviewer;

import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.gui.clusterviewer.ClusterViewerPanelListener;
import ca.pfv.spmf.gui.plot.Plot;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ClusterViewerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Plot plot = null;
    double scaleLevel = 1.0;
    int height;
    int width;
    int originalHeigth;
    int originalWidth;
    private List<Cluster> multipleClusters;
    private Color[] multipleClustersColors;
    double minX = 0.0;
    double maxX = Double.MIN_VALUE;
    double minY = Double.MAX_VALUE;
    double maxY = Double.MIN_VALUE;
    boolean drawTheGrid = false;
    private int markerSize = 5;
    Plot.LegendFormat legendFormat = Plot.LegendFormat.BOTTOM;
    List<ClusterViewerPanelListener> listeners = new ArrayList<ClusterViewerPanelListener>();
    Color[] colors = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.magenta, Color.orange, Color.cyan, Color.pink, Color.darkGray, Color.gray, Color.lightGray};
    private int attributeSelectedX;
    private int attributeSelectedY;

    public ClusterViewerPanel(List<Cluster> clusters, int attributeSelectedX, int attributeSelectedY) {
        this.attributeSelectedX = attributeSelectedX;
        this.attributeSelectedY = attributeSelectedY;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Rectangle area = ClusterViewerPanel.this.plot.getPlotAreaRectangle();
                double x = (double)e.getX() / ClusterViewerPanel.this.scaleLevel - area.getX();
                double y = area.getHeight() - ((double)e.getY() / ClusterViewerPanel.this.scaleLevel - area.getY());
                double chartMouseX = x / (double)area.width * (ClusterViewerPanel.this.maxX - ClusterViewerPanel.this.minX) + ClusterViewerPanel.this.minX;
                double chartMouseY = y / (double)area.height * (ClusterViewerPanel.this.maxY - ClusterViewerPanel.this.minY) + ClusterViewerPanel.this.minY;
                Color colorUnderMouse = Color.WHITE;
                String timeSeriesUnderMouse = "";
                if (chartMouseX < ClusterViewerPanel.this.minX || chartMouseX > ClusterViewerPanel.this.maxX || chartMouseY < ClusterViewerPanel.this.minY || chartMouseY > ClusterViewerPanel.this.maxY) {
                    ClusterViewerPanel.this.setCursor(new Cursor(0));
                    for (ClusterViewerPanelListener listener : ClusterViewerPanel.this.listeners) {
                        listener.notifyMouseOutOfChart();
                    }
                } else {
                    ClusterViewerPanel.this.setCursor(new Cursor(1));
                    try {
                        Robot robot = new Robot();
                        PointerInfo pi = MouseInfo.getPointerInfo();
                        colorUnderMouse = robot.getPixelColor(pi.getLocation().x, pi.getLocation().y);
                    }
                    catch (AWTException e1) {
                        e1.printStackTrace();
                    }
                    for (int i = 0; i < ClusterViewerPanel.this.multipleClustersColors.length; ++i) {
                        if (!colorUnderMouse.equals(ClusterViewerPanel.this.multipleClustersColors[i])) continue;
                        timeSeriesUnderMouse = "Cluster" + (i + 1);
                        break;
                    }
                    for (ClusterViewerPanelListener listener : ClusterViewerPanel.this.listeners) {
                        listener.notifyOfNewMousePosition(chartMouseX, chartMouseY, colorUnderMouse, timeSeriesUnderMouse);
                    }
                }
            }
        });
        this.multipleClusters = clusters;
        this.multipleClustersColors = new Color[this.multipleClusters.size()];
        for (int i = 0; i < this.multipleClusters.size(); ++i) {
            Color alteredColor;
            Color color = this.colors[i % this.colors.length];
            int newBlue = color.getBlue() == 255 ? color.getBlue() : color.getBlue() + 1;
            int newGreen = color.getGreen() == 255 ? color.getGreen() : color.getGreen() + 1;
            int newRed = color.getRed() == 255 ? color.getRed() : color.getRed() + 1;
            this.multipleClustersColors[i] = alteredColor = new Color(newRed, newGreen, newBlue);
        }
        this.width = 600;
        this.originalWidth = 600;
        this.height = 500;
        this.originalHeigth = 500;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.plot = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.width = this.width;
        this.height = this.height;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.scaleLevel, this.scaleLevel);
        Image image = this.drawThePlot();
        g2.drawImage(image, 0, 0, this);
    }

    private Image drawThePlot() {
        Image image = this.createImage(this.width, this.height);
        if (this.multipleClusters.size() == 0) {
            return image;
        }
        Color gridColor = this.drawTheGrid ? Color.BLACK : Color.WHITE;
        this.plot = Plot.plot(Plot.plotOpts().width(this.width).height(this.height).bgColor(Color.WHITE).fgColor(Color.BLACK).labelFont(new Font("Arial", 1, 12)).gridColor(gridColor).legend(this.legendFormat));
        this.minX = 0.0;
        this.maxX = 0.0;
        this.minY = 0.0;
        this.maxY = 0.0;
        boolean seriesCount = false;
        for (int i = 0; i < this.multipleClusters.size(); ++i) {
            boolean count = false;
            Cluster cluster = this.multipleClusters.get(i);
            ClusterViewerPanel clusterViewerPanel = this;
            Plot.Data data = clusterViewerPanel.plot.data();
            for (int j = 0; j < cluster.getVectors().size(); ++j) {
                DoubleArray point = cluster.getVectors().get(j);
                data.xy(point.data[this.attributeSelectedX], point.data[this.attributeSelectedY]);
                if (point.data[1] < this.minY) {
                    this.minY = point.data[1];
                }
                if (point.data[1] > this.maxY) {
                    this.maxY = point.data[1];
                }
                if (point.data[0] < this.minX) {
                    this.minX = point.data[0];
                }
                if (!(point.data[0] > this.maxX)) continue;
                this.maxX = point.data[0];
            }
            Color color = this.multipleClustersColors[i];
            Plot.Marker[] markerTypes = new Plot.Marker[]{Plot.Marker.CIRCLE, Plot.Marker.DIAMOND, Plot.Marker.SQUARE};
            int numberOfBasicColors = this.colors.length;
            int markerIndex = i / numberOfBasicColors % markerTypes.length;
            Plot.Marker markerType = markerTypes[markerIndex];
            this.plot.series("Cluster" + (i + 1), data, Plot.seriesOpts().color(color).line(Plot.Line.NONE).marker(markerType).markerColor(color).markerSize(this.markerSize));
        }
        this.plot.xAxis("x", Plot.axisOpts().format(Plot.AxisFormat.NUMBER)).yAxis("y", Plot.axisOpts());
        this.plot.drawChartOnGraphics2D((Graphics2D)image.getGraphics());
        return image;
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)this.scaleLevel * this.width, (int)this.scaleLevel * this.height);
    }

    public void increaseZoom() {
        this.width = (int)((double)this.width * 2.0);
        this.height = (int)((double)this.height * 2.0);
        this.revalidate();
        this.repaint();
    }

    public void decreaseZoom() {
        if (this.width >= this.originalWidth) {
            this.width /= 2;
            this.height /= 2;
            this.revalidate();
            this.repaint();
        }
    }

    protected void export() {
        String outputFilePath;
        block7: {
            outputFilePath = null;
            try {
                URL main;
                String previousPath = PreferencesManager.getInstance().getOutputFilePath();
                Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
                JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    outputFilePath = file.getPath();
                    if (fc.getSelectedFile() != null) {
                        PreferencesManager.getInstance().setOutputFilePath(fc.getSelectedFile().getParent());
                    }
                    break block7;
                }
                return;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occured while opening the save plot dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
        }
        try {
            if (!outputFilePath.endsWith("png")) {
                outputFilePath = outputFilePath + ".png";
            }
            File outputFile = new File(outputFilePath);
            BufferedImage image = (BufferedImage)this.drawThePlot();
            ImageIO.write((RenderedImage)image, "png", outputFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while attempting to save the plot. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    public void doPrint() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(" SPMF print time series");
        pj.setPrintable(new Printable(){

            @Override
            public int print(Graphics pg, PageFormat pageFormat, int pageNum) throws PrinterException {
                if (pageNum > 0) {
                    return 1;
                }
                Image image = ClusterViewerPanel.this.drawThePlot();
                Graphics2D g2 = (Graphics2D)pg;
                g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                g2.scale(pageFormat.getImageableWidth() / (double)ClusterViewerPanel.this.width, pageFormat.getImageableHeight() / (double)ClusterViewerPanel.this.height);
                g2.drawImage(image, 0, 0, null);
                return 0;
            }
        });
        if (!pj.printDialog()) {
            return;
        }
        try {
            pj.print();
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    public void addListener(ClusterViewerPanelListener listener) {
        this.listeners.add(listener);
    }

    public void setDrawGrid(boolean drawTheGrid) {
        this.drawTheGrid = drawTheGrid;
        this.revalidate();
        this.repaint();
    }

    public void setDrawLegend(Plot.LegendFormat selection) {
        this.legendFormat = selection;
        this.revalidate();
        this.repaint();
    }

    public void setMarkersSize(int selection) {
        this.markerSize = selection;
        this.revalidate();
        this.repaint();
    }

    public void setAttributeSelection(int attributeSelectedX, int attributeSelectedY) {
        this.attributeSelectedX = attributeSelectedX;
        this.attributeSelectedY = attributeSelectedY;
        this.revalidate();
        this.repaint();
    }
}

