/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.instanceviewer;

import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.gui.instanceviewer.InstanceViewerPanelListener;
import ca.pfv.spmf.gui.plot.Plot;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InstancesViewerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Plot plot = null;
    double scaleLevel = 1.0;
    int height;
    int width;
    int originalHeigth;
    int originalWidth;
    private List<DoubleArray> multipleInstances;
    double minX = 0.0;
    double maxX = Double.MIN_VALUE;
    double minY = Double.MAX_VALUE;
    double maxY = Double.MIN_VALUE;
    boolean drawTheGrid = false;
    private int markerSize = 5;
    List<InstanceViewerPanelListener> listeners = new ArrayList<InstanceViewerPanelListener>();
    private int attributeSelectedX;
    private int attributeSelectedY;

    public InstancesViewerPanel(List<DoubleArray> instances, int attributeSelectedX, int attributeSelectedY) {
        this.attributeSelectedX = attributeSelectedX;
        this.attributeSelectedY = attributeSelectedY;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Rectangle area = InstancesViewerPanel.this.plot.getPlotAreaRectangle();
                double x = (double)e.getX() / InstancesViewerPanel.this.scaleLevel - area.getX();
                double y = area.getHeight() - ((double)e.getY() / InstancesViewerPanel.this.scaleLevel - area.getY());
                double chartMouseX = x / (double)area.width * (InstancesViewerPanel.this.maxX - InstancesViewerPanel.this.minX) + InstancesViewerPanel.this.minX;
                double chartMouseY = y / (double)area.height * (InstancesViewerPanel.this.maxY - InstancesViewerPanel.this.minY) + InstancesViewerPanel.this.minY;
                if (chartMouseX < InstancesViewerPanel.this.minX || chartMouseX > InstancesViewerPanel.this.maxX || chartMouseY < InstancesViewerPanel.this.minY || chartMouseY > InstancesViewerPanel.this.maxY) {
                    InstancesViewerPanel.this.setCursor(new Cursor(0));
                    for (InstanceViewerPanelListener listener : InstancesViewerPanel.this.listeners) {
                        listener.notifyMouseOutOfChart();
                    }
                } else {
                    InstancesViewerPanel.this.setCursor(new Cursor(1));
                    for (InstanceViewerPanelListener listener : InstancesViewerPanel.this.listeners) {
                        listener.notifyOfNewMousePosition(chartMouseX, chartMouseY);
                    }
                }
            }
        });
        this.multipleInstances = instances;
        this.width = 600;
        this.originalWidth = 600;
        this.height = 500;
        this.originalHeigth = 500;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.plot = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.scaleLevel, this.scaleLevel);
        Image image = this.drawThePlot();
        g2.drawImage(image, 0, 0, this);
    }

    private Image drawThePlot() {
        Image image = this.createImage(this.width, this.height);
        if (this.multipleInstances.size() == 0) {
            return image;
        }
        this.minX = 0.0;
        this.maxX = 0.0;
        this.minY = 0.0;
        this.maxY = 0.0;
        Color gridColor = this.drawTheGrid ? Color.BLACK : Color.WHITE;
        this.plot = Plot.plot(Plot.plotOpts().width(this.width).height(this.height).bgColor(Color.WHITE).fgColor(Color.BLACK).labelFont(new Font("Arial", 1, 12)).gridColor(gridColor).legend(Plot.LegendFormat.NONE));
        for (int i = 0; i < this.multipleInstances.size(); ++i) {
            DoubleArray instance = this.multipleInstances.get(i);
            InstancesViewerPanel instancesViewerPanel = this;
            Plot.Data data = instancesViewerPanel.plot.data();
            data.xy(instance.data[this.attributeSelectedX], instance.data[this.attributeSelectedY]);
            if (instance.data[1] < this.minY) {
                this.minY = instance.data[1];
            }
            if (instance.data[1] > this.maxY) {
                this.maxY = instance.data[1];
            }
            if (instance.data[0] < this.minX) {
                this.minX = instance.data[0];
            }
            if (instance.data[0] > this.maxX) {
                this.maxX = instance.data[0];
            }
            Color color = Color.BLUE;
            this.plot.series("Point" + (i + 1), data, Plot.seriesOpts().color(color).line(Plot.Line.NONE).marker(Plot.Marker.CIRCLE).markerColor(color).markerSize(this.markerSize));
        }
        this.plot.xAxis("x", Plot.axisOpts().format(Plot.AxisFormat.NUMBER).range(this.minX, this.maxX)).yAxis("y", Plot.axisOpts().range(this.minY, this.maxY));
        this.plot.drawChartOnGraphics2D((Graphics2D)image.getGraphics());
        return image;
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)this.scaleLevel * this.width, (int)this.scaleLevel * this.height);
    }

    public void increaseZoom() {
        this.width = (int)((double)this.width * 2.0);
        this.height = (int)((double)this.height * 2.0);
        this.revalidate();
        this.repaint();
    }

    public void decreaseZoom() {
        if (this.width >= this.originalWidth) {
            this.width /= 2;
            this.height /= 2;
            this.revalidate();
            this.repaint();
        }
    }

    protected void export() {
        String outputFilePath;
        block7: {
            outputFilePath = null;
            try {
                URL main;
                String previousPath = PreferencesManager.getInstance().getOutputFilePath();
                Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
                JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    outputFilePath = file.getPath();
                    if (fc.getSelectedFile() != null) {
                        PreferencesManager.getInstance().setOutputFilePath(fc.getSelectedFile().getParent());
                    }
                    break block7;
                }
                return;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occured while opening the save plot dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
        }
        try {
            if (!outputFilePath.endsWith("png")) {
                outputFilePath = outputFilePath + ".png";
            }
            File outputFile = new File(outputFilePath);
            BufferedImage image = (BufferedImage)this.drawThePlot();
            ImageIO.write((RenderedImage)image, "png", outputFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while attempting to save the plot. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    public void doPrint() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(" SPMF print time series");
        pj.setPrintable(new Printable(){

            @Override
            public int print(Graphics pg, PageFormat pageFormat, int pageNum) throws PrinterException {
                if (pageNum > 0) {
                    return 1;
                }
                Image image = InstancesViewerPanel.this.drawThePlot();
                Graphics2D g2 = (Graphics2D)pg;
                g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                g2.scale(pageFormat.getImageableWidth() / (double)InstancesViewerPanel.this.width, pageFormat.getImageableHeight() / (double)InstancesViewerPanel.this.height);
                g2.drawImage(image, 0, 0, null);
                return 0;
            }
        });
        if (!pj.printDialog()) {
            return;
        }
        try {
            pj.print();
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    public void addListener(InstanceViewerPanelListener listener) {
        this.listeners.add(listener);
    }

    public void setDrawGrid(boolean drawTheGrid) {
        this.drawTheGrid = drawTheGrid;
        this.revalidate();
        this.repaint();
    }

    public void setMarkersSize(int selection) {
        this.markerSize = selection;
        this.revalidate();
        this.repaint();
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setAttributeSelection(int attributeSelectedX, int attributeSelectedY) {
        this.attributeSelectedX = attributeSelectedX;
        this.attributeSelectedY = attributeSelectedY;
        this.revalidate();
        this.repaint();
    }
}

