/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.patternvizualizer;

import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.gui.patternvizualizer.FilterSelectionWindow;
import ca.pfv.spmf.gui.patternvizualizer.PatternTableModel;
import ca.pfv.spmf.gui.patternvizualizer.PatternTableRowFilters;
import ca.pfv.spmf.gui.patternvizualizer.TableColumnAdjuster;
import ca.pfv.spmf.gui.patternvizualizer.filters.AbstractFilter;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableRowSorter;

public class PatternVizualizer
extends JFrame {
    String title = "SPMF - Pattern vizualization tool 2.05";
    private static final long serialVersionUID = -2012129335077139428L;
    JTable table;
    private JLabel labelNumberOfPatterns;
    Vector<List<Object>> data = null;
    Vector<String> columnNames = null;
    Vector<Class> columnClasses = null;
    private JList listFilters;
    private DefaultListModel<String> listModelFilters;
    private JButton btnRemoveFilter;
    private JButton btnRemoveAllFilters;
    PatternTableRowFilters rowFilters = new PatternTableRowFilters();
    private TableRowSorter<PatternTableModel> sorter;
    private PatternTableModel model;
    private JTextField textFieldSearch;
    private JComboBox comboBoxExport;

    public PatternVizualizer(String patternFilePath) throws ParseException, IOException {
        this.setSize(800, 600);
        this.setResizable(false);
        File file = new File(patternFilePath);
        String fileName = file.getName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd, HH:mm");
        String modificationDate = sdf.format(new Date(file.lastModified()));
        this.setTitle(this.title);
        this.getContentPane().setLayout(null);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(22, 41, 572, 462);
        this.getContentPane().add(scrollPane);
        this.table = new JTable();
        this.table.setAutoCreateRowSorter(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        scrollPane.setViewportView(this.table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.labelNumberOfPatterns = new JLabel();
        this.labelNumberOfPatterns.setBounds(22, 514, 189, 14);
        this.getContentPane().add(this.labelNumberOfPatterns);
        double size = (double)file.length() / 1024.0 / 1024.0;
        String fileSize = String.format("%.4f", size);
        JLabel lblFileSizemb = new JLabel("File size (MB): " + fileSize);
        lblFileSizemb.setBounds(221, 535, 174, 14);
        this.getContentPane().add(lblFileSizemb);
        JLabel lblFileName = new JLabel("File name: " + fileName);
        lblFileName.setBounds(22, 535, 224, 14);
        this.getContentPane().add(lblFileName);
        JLabel lblLastModified = new JLabel("Last modified: " + modificationDate);
        lblLastModified.setBounds(405, 535, 217, 14);
        this.getContentPane().add(lblLastModified);
        JLabel lblPatterns = new JLabel("Patterns:");
        lblPatterns.setBounds(22, 16, 77, 14);
        this.getContentPane().add(lblPatterns);
        JLabel lblApplyFilters = new JLabel("Apply filter(s):");
        lblApplyFilters.setBounds(604, 104, 138, 14);
        this.getContentPane().add(lblApplyFilters);
        this.listModelFilters = new DefaultListModel();
        this.readFile(patternFilePath);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        JButton btnAddAFilter = new JButton("Add a filter");
        btnAddAFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FilterSelectionWindow window = new FilterSelectionWindow(PatternVizualizer.this.columnNames, PatternVizualizer.this.columnClasses, PatternVizualizer.this.rowFilters, PatternVizualizer.this);
            }
        });
        btnAddAFilter.setBounds(609, 284, 174, 23);
        this.getContentPane().add(btnAddAFilter);
        this.btnRemoveFilter = new JButton("Remove selected filter");
        this.btnRemoveFilter.setBounds(609, 308, 174, 23);
        this.btnRemoveFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatternVizualizer.this.removeSelectedFilter();
            }
        });
        this.btnRemoveFilter.setEnabled(false);
        this.getContentPane().add(this.btnRemoveFilter);
        this.btnRemoveAllFilters = new JButton("Remove all filters");
        this.btnRemoveAllFilters.setBounds(609, 333, 174, 23);
        this.btnRemoveAllFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatternVizualizer.this.removeAllFilters();
            }
        });
        this.btnRemoveAllFilters.setEnabled(false);
        this.getContentPane().add(this.btnRemoveAllFilters);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(609, 124, 174, 155);
        this.getContentPane().add(scrollPane_1);
        this.listFilters = new JList<String>(this.listModelFilters);
        scrollPane_1.setViewportView(this.listFilters);
        JLabel lblNewLabel = new JLabel("Search:");
        lblNewLabel.setBounds(604, 39, 69, 20);
        this.getContentPane().add(lblNewLabel);
        this.textFieldSearch = new JTextField();
        this.textFieldSearch.setBounds(609, 59, 128, 26);
        this.getContentPane().add(this.textFieldSearch);
        this.textFieldSearch.setColumns(10);
        JButton btnSearch = new JButton("");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatternVizualizer.this.search();
            }
        });
        btnSearch.setIcon(new ImageIcon(PatternVizualizer.class.getResource("/ca/pfv/spmf/gui/patternvizualizer/find.gif")));
        btnSearch.setBounds(738, 59, 30, 26);
        this.getContentPane().add(btnSearch);
        JLabel lblExportTo = new JLabel("Export current view to:");
        lblExportTo.setBounds(604, 372, 138, 20);
        this.getContentPane().add(lblExportTo);
        this.comboBoxExport = new JComboBox();
        this.comboBoxExport.setBounds(609, 396, 138, 26);
        this.getContentPane().add(this.comboBoxExport);
        this.comboBoxExport.addItem("SPMF format");
        this.comboBoxExport.addItem("TSV format");
        this.comboBoxExport.addItem("CSV format");
        JButton buttonExport = new JButton("");
        buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternVizualizer.this.export();
            }
        });
        buttonExport.setIcon(new ImageIcon(PatternVizualizer.class.getResource("/ca/pfv/spmf/gui/patternvizualizer/save.gif")));
        buttonExport.setBounds(753, 396, 30, 26);
        this.getContentPane().add(buttonExport);
        this.listFilters.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                PatternVizualizer.this.selectFilter(arg0);
            }
        });
        this.setVisible(true);
    }

    private void readFile(String patternFilePath) throws IOException {
        String line;
        int numberOfPatterns = 0;
        this.data = new Vector();
        this.columnNames = new Vector();
        this.columnClasses = new Vector();
        this.columnClasses.add(String.class);
        this.columnNames.add("Pattern");
        BufferedReader br = new BufferedReader(new FileReader(patternFilePath));
        while ((line = br.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ArrayList<Object> lineData = new ArrayList<Object>();
            int positionFirstDelimiter = line.indexOf(" #");
            if (positionFirstDelimiter == -1) {
                lineData.add(line.substring(0, line.length()));
            } else {
                lineData.add(line.substring(0, positionFirstDelimiter));
                String cutLine = line;
                while (positionFirstDelimiter >= 0) {
                    Double doubleValue;
                    cutLine = cutLine.substring(positionFirstDelimiter + 1, cutLine.length());
                    int positionFirstSpace = cutLine.indexOf(32, 1);
                    int positionNextDelimiter = cutLine.indexOf(" #", 1);
                    String attributeName = cutLine.substring(0, positionFirstSpace);
                    String attributeValue = positionNextDelimiter == -1 ? cutLine.substring(positionFirstSpace + 1, cutLine.length()) : cutLine.substring(positionFirstSpace + 1, positionNextDelimiter);
                    if (numberOfPatterns == 0) {
                        this.columnNames.add(attributeName);
                    }
                    if ((doubleValue = this.isDouble(attributeValue)) != null) {
                        if (numberOfPatterns == 0) {
                            this.columnClasses.add(Double.class);
                        }
                        lineData.add(doubleValue);
                        positionFirstDelimiter = positionNextDelimiter;
                        continue;
                    }
                    Integer integerValue = this.isInteger(attributeValue);
                    if (integerValue != null) {
                        if (numberOfPatterns == 0) {
                            this.columnClasses.add(Double.class);
                        }
                        this.columnClasses.add(Integer.class);
                        lineData.add(integerValue);
                        positionFirstDelimiter = positionNextDelimiter;
                        continue;
                    }
                    Boolean booleanValue = this.isBoolean(attributeValue);
                    if (booleanValue != null) {
                        if (numberOfPatterns == 0) {
                            this.columnClasses.add(Boolean.class);
                        }
                        this.columnClasses.add(Boolean.class);
                        lineData.add(booleanValue);
                        positionFirstDelimiter = positionNextDelimiter;
                        continue;
                    }
                    this.columnClasses.add(String.class);
                    lineData.add(attributeValue);
                    positionFirstDelimiter = positionNextDelimiter;
                }
            }
            this.data.add(lineData);
            ++numberOfPatterns;
        }
        br.close();
        if (numberOfPatterns == 0) {
            return;
        }
        this.model = new PatternTableModel(this.data, this.columnNames, this.columnClasses);
        this.table.setModel(this.model);
        this.sorter = new TableRowSorter<PatternTableModel>(this.model);
        this.table.setRowSorter(this.sorter);
        this.sorter.setRowFilter(this.rowFilters);
        TableColumnAdjuster tca = new TableColumnAdjuster(this.table);
        tca.adjustColumns();
        this.refreshNumberOfPatternsDisplayed();
    }

    private Double isDouble(String token) {
        Double result = null;
        try {
            result = Double.valueOf(token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Integer isInteger(String token) {
        Integer result = null;
        try {
            result = Integer.valueOf(token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Boolean isBoolean(String token) {
        if ("true".equals(token)) {
            return Boolean.TRUE;
        }
        if ("false".equals(token)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void filtersHaveBeenUpdated() {
        this.listModelFilters.clear();
        for (int i = 0; i < this.rowFilters.filters.size(); ++i) {
            AbstractFilter filter = this.rowFilters.filters.get(i);
            this.listModelFilters.addElement(filter.getFilterWithParameterName());
        }
        if (this.rowFilters.filters.size() >= 0) {
            this.btnRemoveAllFilters.setEnabled(true);
        }
        for (TableModelListener listener : this.model.listeners) {
            listener.tableChanged(new TableModelEvent(this.model));
        }
        this.refreshNumberOfPatternsDisplayed();
    }

    protected void selectFilter(ListSelectionEvent arg0) {
        if (this.listFilters.getSelectedIndex() > -1) {
            this.btnRemoveFilter.setEnabled(true);
        }
    }

    private void removeSelectedFilter() {
        int index = this.listFilters.getSelectedIndex();
        this.listModelFilters.remove(index);
        this.rowFilters.filters.remove(index);
        this.btnRemoveFilter.setEnabled(false);
        if (this.rowFilters.filters.size() == 0) {
            this.btnRemoveAllFilters.setEnabled(false);
        }
        for (TableModelListener listener : this.model.listeners) {
            listener.tableChanged(new TableModelEvent(this.model));
        }
        this.refreshNumberOfPatternsDisplayed();
    }

    private void removeAllFilters() {
        this.listModelFilters.clear();
        this.rowFilters.filters.clear();
        this.btnRemoveAllFilters.setEnabled(false);
        this.btnRemoveFilter.setEnabled(false);
        for (TableModelListener listener : this.model.listeners) {
            listener.tableChanged(new TableModelEvent(this.model));
        }
        this.refreshNumberOfPatternsDisplayed();
    }

    private void refreshNumberOfPatternsDisplayed() {
        this.labelNumberOfPatterns.setText("Number of patterns: " + this.table.getRowCount());
    }

    protected void export() {
        String outputFilePath;
        String selection;
        block11: {
            selection = (String)this.comboBoxExport.getSelectedItem();
            outputFilePath = null;
            try {
                URL main;
                String previousPath = PreferencesManager.getInstance().getOutputFilePath();
                Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
                JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    outputFilePath = file.getPath();
                    if (fc.getSelectedFile() != null) {
                        PreferencesManager.getInstance().setOutputFilePath(fc.getSelectedFile().getParent());
                    }
                    break block11;
                }
                return;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occured while opening the output file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
        }
        try {
            if ("CSV format".equals(selection)) {
                this.exportToCSV(this.table, outputFilePath);
            } else if ("TSV format".equals(selection)) {
                this.exportToTSV(this.table, outputFilePath);
            } else if ("SPMF format".equals(selection)) {
                this.exportToSPMFFormat(this.table, outputFilePath);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while attempting to save the file. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    private void exportToSPMFFormat(JTable table2, String outputFilePath) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                if (j == 0) {
                    writer.write(this.table.getValueAt(i, j).toString());
                } else {
                    writer.write(this.columnNames.get(j));
                    writer.write(32);
                    writer.write(this.table.getValueAt(i, j).toString());
                }
                if (j == this.table.getColumnCount() - 1) continue;
                writer.write(32);
            }
            writer.newLine();
        }
        writer.close();
    }

    public void exportToTSV(JTable table, String filepath) throws IOException {
        int i;
        BufferedWriter writer = new BufferedWriter(new FileWriter(filepath));
        for (i = 0; i < table.getColumnCount(); ++i) {
            writer.write(table.getColumnName(i));
            if (i == table.getColumnCount() - 1) continue;
            writer.write(9);
        }
        writer.newLine();
        for (i = 0; i < table.getRowCount(); ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                writer.write(table.getValueAt(i, j).toString());
                if (j == table.getColumnCount() - 1) continue;
                writer.write(9);
            }
            writer.newLine();
        }
        writer.close();
    }

    public void exportToCSV(JTable table, String filepath) throws IOException {
        int i;
        BufferedWriter writer = new BufferedWriter(new FileWriter(filepath));
        for (i = 0; i < table.getColumnCount(); ++i) {
            String string = table.getColumnName(i);
            if (string.indexOf(44) != -1) {
                string = '\"' + string + '\"';
            }
            writer.write(string);
            if (i == table.getColumnCount() - 1) continue;
            writer.write(44);
        }
        writer.newLine();
        for (i = 0; i < table.getRowCount(); ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                String string = table.getValueAt(i, j).toString();
                if (string.indexOf(44) != -1) {
                    string = '\"' + string + '\"';
                }
                writer.write(string);
                if (j == table.getColumnCount() - 1) continue;
                writer.write(44);
            }
            writer.newLine();
        }
        writer.close();
    }

    protected void search() {
        String text = this.textFieldSearch.getText();
        if (text.length() == 0) {
            return;
        }
        int currentRow = this.table.getSelectedRow();
        int currentColumn = this.table.getSelectedColumn();
        ++currentColumn;
        if (currentRow == -1) {
            currentRow = 0;
        }
        while (currentRow < this.table.getRowCount()) {
            while (currentColumn < this.table.getColumnCount()) {
                if (this.table.getValueAt(currentRow, currentColumn).toString().contains(text)) {
                    this.table.changeSelection(currentRow, currentColumn, false, false);
                    return;
                }
                ++currentColumn;
            }
            currentColumn = 0;
            ++currentRow;
        }
    }
}

