/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.sequence_database_array_integers;

import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SequenceDatabase {
    public int minItem = Integer.MAX_VALUE;
    public int maxItem = 0;
    public int tidsCount = 0;
    private final List<Sequence> sequences = new ArrayList<Sequence>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.addSequence(thisLine.split(" "));
            }
        }
    }

    public void addSequence(String[] tokens) {
        Sequence sequence = new Sequence();
        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
        for (String token : tokens) {
            if (token.codePointAt(0) == 60) continue;
            if (token.equals("-1")) {
                sequence.addItemset(itemset2.toArray());
                itemset2 = new ArrayList();
                continue;
            }
            if (token.equals("-2")) {
                this.sequences.add(sequence);
                continue;
            }
            Integer item = Integer.parseInt(token);
            if (item >= this.maxItem) {
                this.maxItem = item;
            }
            if (item < this.minItem) {
                this.minItem = item;
            }
            itemset2.add(item);
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void print() {
        System.out.println("============  CONTEXTE ==========");
        for (int i = 0; i < this.sequences.size(); ++i) {
            System.out.print(i + ":  ");
            this.sequences.get(i).print();
            System.out.println("");
        }
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        System.out.println("Min item:" + this.minItem);
        System.out.println("Max item:" + this.maxItem);
        long size = 0L;
        for (Sequence sequence : this.sequences) {
            size += (long)sequence.size();
        }
        double meansize = (float)size / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.sequences.size(); ++i) {
            r.append(i);
            r.append(":  ");
            r.append(this.sequences.get(i).toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }
}

