/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.sequence_database_list_integers;

import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SequenceDatabase {
    private final List<Sequence> sequences = new ArrayList<Sequence>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            boolean i = false;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.addSequence(thisLine.split(" "));
            }
        }
    }

    void addSequence(String[] tokens) {
        Sequence sequence = new Sequence(this.sequences.size());
        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
        for (String token : tokens) {
            if (token.codePointAt(0) == 60) continue;
            if (token.equals("-1")) {
                sequence.addItemset(itemset2);
                itemset2 = new ArrayList();
                continue;
            }
            if (token.equals("-2")) {
                this.sequences.add(sequence);
                continue;
            }
            itemset2.add(Integer.parseInt(token));
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void print() {
        System.out.println("============  SEQUENCE DATABASE ==========");
        for (Sequence sequence : this.sequences) {
            System.out.print(sequence.getId() + ":  ");
            sequence.print();
            System.out.println("");
        }
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        long size = 0L;
        for (Sequence sequence : this.sequences) {
            size += (long)sequence.size();
        }
        double meansize = (float)size / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public Set<Integer> getSequenceIDs() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Sequence sequence : this.getSequences()) {
            set.add(sequence.getId());
        }
        return set;
    }
}

