/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.sequence_database_list_strings;

import ca.pfv.spmf.input.sequence_database_list_strings.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SequenceDatabase {
    private final List<Sequence> sequences = new ArrayList<Sequence>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.addSequence(thisLine.split(" "));
            }
        }
    }

    void addSequence(String[] tokens) {
        Sequence sequence = new Sequence(this.sequences.size());
        ArrayList<String> itemset2 = new ArrayList<String>();
        for (String item : tokens) {
            if (item.codePointAt(0) == 60) continue;
            if (item.equals("-1")) {
                Collections.sort(itemset2, new Comparator<String>(){

                    @Override
                    public int compare(String arg0, String arg1) {
                        return arg0.hashCode() - arg1.hashCode();
                    }
                });
                sequence.addItemset(itemset2);
                itemset2 = new ArrayList();
                continue;
            }
            if (item.equals("-2")) {
                this.sequences.add(sequence);
                continue;
            }
            itemset2.add(item);
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void printDatabase() {
        System.out.println("============  Database ==========");
        for (Sequence sequence : this.sequences) {
            System.out.print(sequence.getId() + ":  ");
            sequence.print();
            System.out.println("");
        }
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        long size = 0L;
        for (Sequence sequence : this.sequences) {
            size += (long)sequence.size();
        }
        double meansize = (float)size / (float)this.sequences.size();
        System.out.println("Average sequence size : " + meansize);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public Set<Integer> getSequenceIDs() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Sequence sequence : this.getSequences()) {
            set.add(sequence.getId());
        }
        return set;
    }
}

