/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.transaction_database_list_integers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransactionDatabase {
    private final Set<Integer> items = new HashSet<Integer>();
    private final List<List<Integer>> transactions = new ArrayList<List<Integer>>();

    public void addTransaction(List<Integer> transaction) {
        this.transactions.add(transaction);
        this.items.addAll(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.addTransaction(thisLine.split(" "));
            }
        }
    }

    private void addTransaction(String[] itemsString) {
        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
        for (String attribute : itemsString) {
            int item = Integer.parseInt(attribute);
            itemset2.add(item);
            this.items.add(item);
        }
        this.transactions.add(itemset2);
    }

    public void printDatabase() {
        System.out.println("===================  TRANSACTION DATABASE ===================");
        int count = 0;
        for (List<Integer> itemset2 : this.transactions) {
            System.out.print(count + ":  ");
            this.print(itemset2);
            ++count;
        }
    }

    private void print(List<Integer> itemset2) {
        StringBuilder r = new StringBuilder();
        for (Integer item : itemset2) {
            r.append(item.toString());
            r.append(' ');
        }
        System.out.println(r);
    }

    public int size() {
        return this.transactions.size();
    }

    public List<List<Integer>> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getItems() {
        return this.items;
    }
}

