/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns;

import ca.pfv.spmf.patterns.AbstractItemset;

public abstract class AbstractOrderedItemset
extends AbstractItemset {
    @Override
    public abstract int getAbsoluteSupport();

    @Override
    public abstract int size();

    public abstract Integer get(int var1);

    public Integer getLastItem() {
        return this.get(this.size() - 1);
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "EMPTYSET";
        }
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            r.append(this.get(i));
            r.append(' ');
        }
        return r.toString();
    }

    @Override
    public double getRelativeSupport(int nbObject) {
        return (double)this.getAbsoluteSupport() / (double)nbObject;
    }

    @Override
    public boolean contains(Integer item) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(item)) {
                return true;
            }
            if (this.get(i) <= item) continue;
            return false;
        }
        return false;
    }

    public boolean containsAll(AbstractOrderedItemset itemset2) {
        if (this.size() < itemset2.size()) {
            return false;
        }
        int i = 0;
        for (int j = 0; j < itemset2.size(); ++j) {
            boolean found = false;
            while (!found && i < this.size()) {
                if (this.get(i).equals(itemset2.get(j))) {
                    found = true;
                } else if (this.get(i) > itemset2.get(j)) {
                    return false;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualTo(AbstractOrderedItemset itemset2) {
        if (this.size() != itemset2.size()) {
            return false;
        }
        for (int i = 0; i < itemset2.size(); ++i) {
            if (itemset2.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualTo(int[] itemset2) {
        if (this.size() != itemset2.length) {
            return false;
        }
        for (int i = 0; i < itemset2.length; ++i) {
            if (itemset2[i] == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean allTheSameExceptLastItemV2(AbstractOrderedItemset itemset2) {
        if (itemset2.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size() - 1; ++i) {
            if (this.get(i).equals(itemset2.get(i))) continue;
            return false;
        }
        return true;
    }

    public Integer allTheSameExceptLastItem(AbstractOrderedItemset itemset2) {
        if (itemset2.size() != this.size()) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!(i == this.size() - 1 ? this.get(i) >= itemset2.get(i) : !this.get(i).equals(itemset2.get(i)))) continue;
            return null;
        }
        return itemset2.get(itemset2.size() - 1);
    }
}

