/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns.cluster;

import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;

public class ClusterWithMean
extends Cluster {
    private DoubleArray mean;
    DoubleArray sum;

    public ClusterWithMean(int vectorsSize) {
        this.sum = new DoubleArray(new double[vectorsSize]);
    }

    public void setMean(DoubleArray mean) {
        this.mean = mean;
    }

    @Override
    public void addVector(DoubleArray vector) {
        super.addVector(vector);
        for (int i = 0; i < vector.data.length; ++i) {
            int n = i;
            this.sum.data[n] = this.sum.data[n] + vector.data[i];
        }
    }

    public DoubleArray getmean() {
        return this.mean;
    }

    public void recomputeClusterMean() {
        for (int i = 0; i < this.sum.data.length; ++i) {
            this.mean.data[i] = this.sum.data[i] / (double)this.vectors.size();
        }
    }

    @Override
    public void remove(DoubleArray vector) {
        super.remove(vector);
        for (int i = 0; i < vector.data.length; ++i) {
            int n = i;
            this.sum.data[n] = this.sum.data[n] - vector.data[i];
        }
    }
}

