/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns.cluster;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.ClusterWithMean;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import java.util.List;

public class ClustersEvaluation {
    public static double calculateSSE(List<ClusterWithMean> clusters, DistanceFunction distanceFunction) {
        double sse = 0.0;
        for (ClusterWithMean cluster : clusters) {
            for (DoubleArray vector : cluster.getVectors()) {
                sse += Math.pow(distanceFunction.calculateDistance(vector, cluster.getmean()), 2.0);
            }
        }
        return sse;
    }

    public static double getSSE(List<Cluster> clusters, DistanceFunction distanceFunction) {
        double sse = 0.0;
        for (Cluster cluster : clusters) {
            if (cluster.getVectors().size() <= 0) continue;
            DoubleArray mean = ClustersEvaluation.calculateClusterMeans(cluster);
            for (DoubleArray vector : cluster.getVectors()) {
                sse += Math.pow(distanceFunction.calculateDistance(vector, mean), 2.0);
            }
        }
        return sse;
    }

    public static DoubleArray calculateClusterMeans(Cluster cluster) {
        int dimensionCount = cluster.getVectors().get((int)0).data.length;
        double[] mean = new double[dimensionCount];
        for (DoubleArray vector : cluster.getVectors()) {
            for (int i = 0; i < dimensionCount; ++i) {
                int n = i;
                mean[n] = mean[n] + vector.data[i];
            }
        }
        for (int i = 0; i < dimensionCount; ++i) {
            mean[i] = mean[i] / (double)cluster.getVectors().size();
        }
        return new DoubleArray(mean);
    }
}

