/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns.itemset_array_integers_with_count;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.patterns.AbstractOrderedItemset;
import java.util.Arrays;
import java.util.List;

public class Itemset
extends AbstractOrderedItemset {
    public int[] itemset;
    public int support = 0;

    public int[] getItems() {
        return this.itemset;
    }

    public Itemset() {
        this.itemset = new int[0];
    }

    public Itemset(int item) {
        this.itemset = new int[]{item};
    }

    public Itemset(int[] items) {
        this.itemset = items;
    }

    public Itemset(List<Integer> itemset2, int support) {
        this.itemset = new int[itemset2.size()];
        int i = 0;
        for (Integer item : itemset2) {
            this.itemset[i++] = item;
        }
        this.support = support;
    }

    @Override
    public int getAbsoluteSupport() {
        return this.support;
    }

    @Override
    public int size() {
        return this.itemset.length;
    }

    @Override
    public Integer get(int position) {
        return this.itemset[position];
    }

    public void setAbsoluteSupport(Integer support) {
        this.support = support;
    }

    public void increaseTransactionCount() {
        ++this.support;
    }

    public Itemset cloneItemSetMinusOneItem(Integer itemToRemove) {
        int[] newItemset = new int[this.itemset.length - 1];
        int i = 0;
        for (int j = 0; j < this.itemset.length; ++j) {
            if (this.itemset[j] == itemToRemove) continue;
            newItemset[i++] = this.itemset[j];
        }
        return new Itemset(newItemset);
    }

    public Itemset cloneItemSetMinusAnItemset(Itemset itemsetToNotKeep) {
        int[] newItemset = new int[this.itemset.length - itemsetToNotKeep.size()];
        int i = 0;
        for (int j = 0; j < this.itemset.length; ++j) {
            if (itemsetToNotKeep.contains(this.itemset[j])) continue;
            newItemset[i++] = this.itemset[j];
        }
        return new Itemset(newItemset);
    }

    public Itemset intersection(Itemset itemset2) {
        int[] intersection = ArraysAlgos.intersectTwoSortedArrays(this.getItems(), itemset2.getItems());
        return new Itemset(intersection);
    }

    public int hashCode() {
        return Arrays.hashCode(this.itemset);
    }
}

