/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceStatsGenerator;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPT.CPTPredictor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;

public class MainTestCPT {
    public static void main(String[] arg) throws IOException {
        String inputPath = MainTestCPT.fileToPath("contextCPT.txt");
        SequenceDatabase trainingSet = new SequenceDatabase();
        trainingSet.loadFileSPMFFormat(inputPath, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        System.out.println("--- Training sequences ---");
        for (Sequence sequence : trainingSet.getSequences()) {
            System.out.println(sequence.toString());
        }
        System.out.println();
        SequenceStatsGenerator.prinStats(trainingSet, " training sequences ");
        String optionalParameters = "splitLength:6 splitMethod:0 recursiveDividerMin:1 recursiveDividerMax:5";
        CPTPredictor predictionModel = new CPTPredictor("CPT", optionalParameters);
        predictionModel.Train(trainingSet.getSequences());
        Sequence sequence = new Sequence(0);
        sequence.addItem(new Item(1));
        sequence.addItem(new Item(4));
        Sequence thePrediction = predictionModel.Predict(sequence);
        System.out.println("For the sequence <(1),(4)>, the prediction for the next symbol is: +" + thePrediction);
        System.out.println();
        System.out.println("To make the prediction, the scores were calculated as follows:");
        Map<Integer, Float> countTable = predictionModel.getCountTable();
        for (Map.Entry<Integer, Float> entry : countTable.entrySet()) {
            System.out.println("symbol" + entry.getKey() + "\t score: " + entry.getValue());
        }
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestCPT.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

